/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting;

import com.cedarsoftware.util.io.JsonReader;
import com.github.mkolisnyk.cucumber.reporting.CucumberResultsCommon;
import com.github.mkolisnyk.cucumber.reporting.types.knownerrors.KnownErrorsModel;
import com.github.mkolisnyk.cucumber.reporting.types.knownerrors.KnownErrorsResult;
import com.github.mkolisnyk.cucumber.reporting.types.knownerrors.KnownErrorsResultSet;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberFeatureResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberScenarioResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;

public class CucumberKnownErrorsReport
extends CucumberResultsCommon {
    protected String getReportBase() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/known-errors-report-tmpl.html");
        String result = IOUtils.toString((InputStream)is);
        return result;
    }

    public String generateKnownErrorsReport(CucumberFeatureResult[] features, KnownErrorsModel model) throws Exception {
        String content = this.getReportBase();
        content = content.replaceAll("__TITLE__", "Known Errors");
        String reportContent = "";
        Object[] scenarios = new CucumberScenarioResult[]{};
        for (CucumberFeatureResult feature : features) {
            scenarios = (CucumberScenarioResult[])ArrayUtils.addAll((Object[])scenarios, (Object[])feature.getElements());
        }
        KnownErrorsResultSet results = new KnownErrorsResultSet();
        results.valuate((CucumberScenarioResult[])scenarios, model);
        for (KnownErrorsResult result : results.getResults()) {
            reportContent = reportContent.concat(String.format("<tr class=\"%s\"><td><p><b>%s</b></p><p>%s</p></td><td>%s</td><td>%d</td></tr>", new Object[]{result.getInfo().getPriority().toString().toLowerCase(), result.getInfo().getTitle(), result.getInfo().getDescription(), result.getInfo().getPriority(), result.getFrequency()}));
        }
        content = content.replaceAll("__REPORT__", reportContent);
        return content;
    }

    public void executeKnownErrorsReport(KnownErrorsModel model) throws Exception {
        this.executeKnownErrorsReport(model, false);
    }

    public void executeKnownErrorsReport(KnownErrorsModel model, boolean toPDF) throws Exception {
        CucumberFeatureResult[] features = this.readFileContent(true);
        File outFile = new File(this.getOutputDirectory() + File.separator + this.getOutputName() + "-known-errors.html");
        FileUtils.writeStringToFile((File)outFile, (String)this.generateKnownErrorsReport(features, model));
        if (toPDF) {
            this.exportToPDF(outFile, "known-errors");
        }
    }

    public void executeKnownErrorsReport(File config) throws Exception {
        this.executeKnownErrorsReport(config, false);
    }

    public void executeKnownErrorsReport(File config, boolean toPDF) throws Exception {
        KnownErrorsModel model = (KnownErrorsModel)JsonReader.jsonToJava((String)FileUtils.readFileToString((File)config));
        this.executeKnownErrorsReport(model, toPDF);
    }
}

