/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting;

import com.cedarsoftware.util.io.JsonReader;
import com.github.mkolisnyk.cucumber.reporting.CucumberResultsCommon;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.BreakdownStats;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberFeatureResult;
import com.github.mkolisnyk.cucumber.reporting.types.retrospective.RetrospectiveBatch;
import com.github.mkolisnyk.cucumber.reporting.types.retrospective.RetrospectiveModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class CucumberRetrospectiveOverviewReport
extends CucumberResultsCommon {
    protected String getReportBase() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/consolidated-tmpl.html");
        String result = IOUtils.toString((InputStream)is);
        return result;
    }

    private String[] getFileNames(String rootFolder) throws Exception {
        Object[] fileNames = new String[]{};
        for (File file : new File(rootFolder).listFiles()) {
            fileNames = file.isDirectory() ? (String[])ArrayUtils.addAll((Object[])fileNames, (Object[])this.getFileNames(file.getAbsolutePath())) : (String[])ArrayUtils.add((Object[])fileNames, (Object)file.getAbsolutePath());
        }
        return fileNames;
    }

    private String[] getFilesByMask(String mask) throws Exception {
        String[] input;
        Object[] result = new String[]{};
        for (String fileName : input = this.getFileNames(".")) {
            if (!fileName.matches(mask)) continue;
            result = (String[])ArrayUtils.add((Object[])result, (Object)fileName);
        }
        return result;
    }

    private BreakdownStats[] calculateStats(String[] files) throws Exception {
        Object[] result = new BreakdownStats[]{};
        for (String file : files) {
            CucumberFeatureResult[] features;
            BreakdownStats stat = new BreakdownStats();
            for (CucumberFeatureResult feature : features = this.readFileContent(file, true)) {
                feature.valuate();
                stat.addPassed(feature.getPassed());
                stat.addFailed(feature.getFailed());
                stat.addSkipped(feature.getSkipped() + feature.getUndefined());
            }
            result = (BreakdownStats[])ArrayUtils.add((Object[])result, (Object)stat);
        }
        return result;
    }

    private String drawBarChart(RetrospectiveModel model, BreakdownStats stats, int offset, int barSize) {
        double total = stats.getFailed() + stats.getPassed() + stats.getSkipped();
        double scale = 0.9;
        if (total > 0.0) {
            int passedRatio = (int)(0.9 * (double)model.getHeight() * ((double)stats.getPassed() / total));
            int failedRatio = (int)(0.9 * (double)model.getHeight() * ((double)stats.getFailed() / total));
            int skippedRatio = (int)(0.9 * (double)model.getHeight() * ((double)stats.getSkipped() / total));
            String content = String.format("<rect x=\"%d\" y=\"%d\" width=\"%d\" height=\"%d\" stroke=\"black\" stroke-width=\"1\" fill=\"silver\"></rect><rect x=\"%d\" y=\"%d\" width=\"%d\" height=\"%d\" stroke=\"red\" stroke-width=\"1\" fill=\"red\"></rect><rect x=\"%d\" y=\"%d\" width=\"%d\" height=\"%d\" stroke=\"silver\" stroke-width=\"1\" fill=\"green\"></rect>", (int)((double)offset * 0.9 * (double)barSize), 0, (int)(0.9 * (double)barSize), skippedRatio, (int)((double)offset * 0.9 * (double)barSize), skippedRatio, (int)(0.9 * (double)barSize), failedRatio, (int)((double)offset * 0.9 * (double)barSize), failedRatio + skippedRatio, (int)(0.9 * (double)barSize), passedRatio);
            int scaleTicksCount = 5;
            int maxScaleValue = 100;
            int vOffset = 10;
            for (int i = 0; i <= 5; ++i) {
                content = content.concat(String.format("<text x=\"%d\" y=\"%d\" font-size=\"12\">%d%%</text>", (int)((double)model.getWidth() * 0.9), (int)((double)i * 0.9 * (double)model.getHeight() / 5.0) + 10, 100 - i * 100 / 5));
                content = content.concat(String.format("<line stroke-dasharray=\"10,10\" x1=\"0\" y1=\"%d\" x2=\"%d\" y2=\"%d\" style=\"stroke:darkgray;stroke-width:1\" />", (int)((double)i * 0.9 * (double)model.getHeight() / 5.0), (int)((double)model.getWidth() * 0.9), (int)((double)i * 0.9 * (double)model.getHeight() / 5.0)));
            }
            content = content.concat(String.format("<text x=\"%d\" y=\"%d\" font-size=\"12\">%d</text>", (int)((double)offset * 0.9 * (double)barSize) + barSize / 2, (int)(0.9 * (double)model.getHeight()) + 10, offset + 1));
            return content;
        }
        return "";
    }

    private String drawGraph(RetrospectiveModel model, BreakdownStats[] stats) {
        double scale = 0.9;
        String content = String.format("<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" width=\"%d\" height=\"%d\">", model.getWidth(), model.getHeight());
        int offset = 0;
        int barSize = model.getWidth() / stats.length;
        for (BreakdownStats stat : stats) {
            content = content.concat(this.drawBarChart(model, stat, offset, barSize));
            ++offset;
        }
        content = content + "</svg>";
        return content;
    }

    private String generateRetrospectiveReport(RetrospectiveModel model, BreakdownStats[] stats) throws Exception {
        String result = this.getReportBase();
        result = result.replaceAll("__TITLE__", model.getTitle());
        if (model.getRefreshTimeout() > 0 && StringUtils.isNotBlank((CharSequence)model.getRedirectTo())) {
            String refreshHeader = String.format("<meta http-equiv=\"Refresh\" content=\"%d; url=%s\" />", model.getRefreshTimeout(), model.getRedirectTo());
            result = result.replaceAll("__REFRESH__", refreshHeader);
        } else {
            result = result.replaceAll("__REFRESH__", "");
        }
        String reportContent = "<h1>" + model.getTitle() + "</h1>" + this.drawGraph(model, stats);
        reportContent = this.replaceHtmlEntitiesWithCodes(reportContent);
        reportContent = reportContent.replaceAll("[$]", "&#36;");
        result = result.replaceAll("__REPORT__", reportContent);
        return result;
    }

    public void executeReport(RetrospectiveModel model, boolean aggregate, boolean toPDF) throws Exception {
        String[] files = this.getFilesByMask(model.getMask());
        BreakdownStats[] stats = this.calculateStats(files);
        File outFile = new File(this.getOutputDirectory() + File.separator + this.getOutputName() + "-" + model.getReportSuffix() + ".html");
        FileUtils.writeStringToFile((File)outFile, (String)this.generateRetrospectiveReport(model, stats));
        if (toPDF) {
            this.exportToPDF(outFile, model.getReportSuffix());
        }
    }

    public void executeReport(RetrospectiveBatch batch, boolean aggregate, boolean toPDF) throws Exception {
        for (RetrospectiveModel model : batch.getModels()) {
            this.executeReport(model, aggregate, toPDF);
        }
    }

    public void executeReport(File config, boolean aggregate, boolean toPDF) throws Exception {
        RetrospectiveBatch batch = (RetrospectiveBatch)JsonReader.jsonToJava((String)FileUtils.readFileToString((File)config));
        this.executeReport(batch, aggregate, toPDF);
    }
}

