/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting.types.breakdown;

import com.github.mkolisnyk.cucumber.reporting.types.breakdown.BreakdownCellDisplayType;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.BreakdownCellValue;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.BreakdownStats;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.DataDimension;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.matchers.BaseMatcher;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.matchers.Matcher;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.valuators.ScenarioValuator;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.valuators.StepsValuator;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.valuators.Valuator;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberScenarioResult;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class BreakdownTable {
    private static final Map<BreakdownCellValue, Valuator> VALUATORS_MAP = new HashMap<BreakdownCellValue, Valuator>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(BreakdownCellValue.FEATURES, null);
            this.put(BreakdownCellValue.SCENARIOS, new ScenarioValuator());
            this.put(BreakdownCellValue.STEPS, new StepsValuator());
        }
    };
    private DataDimension rows;
    private DataDimension cols;
    private BreakdownCellValue cell;
    private BreakdownCellDisplayType displayType;

    public BreakdownTable() {
        this(DataDimension.allFeatures(), DataDimension.allScenarios(), BreakdownCellValue.STEPS);
    }

    public BreakdownTable(BreakdownCellDisplayType displayTypeValue) {
        this(DataDimension.allFeatures(), DataDimension.allScenarios(), BreakdownCellValue.STEPS, displayTypeValue);
    }

    public BreakdownTable(DataDimension rowsValue, DataDimension colsValue) {
        this(rowsValue, colsValue, BreakdownCellValue.STEPS);
    }

    public BreakdownTable(DataDimension rowsValue, DataDimension colsValue, BreakdownCellValue cellValue) {
        this(rowsValue, colsValue, cellValue, BreakdownCellDisplayType.BARS_ONLY);
    }

    public BreakdownTable(DataDimension rowsValue, DataDimension colsValue, BreakdownCellDisplayType displayTypeValue) {
        this(rowsValue, colsValue, BreakdownCellValue.STEPS, displayTypeValue);
    }

    public BreakdownTable(DataDimension rowsValue, DataDimension colsValue, BreakdownCellValue cellValue, BreakdownCellDisplayType displayTypeValue) {
        this.rows = rowsValue;
        this.cols = colsValue;
        this.cell = cellValue;
        this.displayType = displayTypeValue;
    }

    public DataDimension getRows() {
        return this.rows;
    }

    public void setRows(DataDimension rowsValue) {
        this.rows = rowsValue;
    }

    public DataDimension getCols() {
        return this.cols;
    }

    public void setCols(DataDimension colsValue) {
        this.cols = colsValue;
    }

    public BreakdownCellValue getCell() {
        return this.cell;
    }

    public void setCell(BreakdownCellValue cellValue) {
        this.cell = cellValue;
    }

    public BreakdownCellDisplayType getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(BreakdownCellDisplayType displayTypeValue) {
        this.displayType = displayTypeValue;
    }

    public CucumberScenarioResult[] filter(CucumberScenarioResult[] array, DataDimension[] filters) {
        Object[] result = new CucumberScenarioResult[]{};
        for (CucumberScenarioResult item : array) {
            boolean matches = true;
            for (DataDimension filter : filters) {
                Matcher matcher = BaseMatcher.create(filter.getDimensionValue());
                if (matcher.matches(item, filter)) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            result = (CucumberScenarioResult[])ArrayUtils.add((Object[])result, (Object)item);
        }
        return result;
    }

    public BreakdownStats valuateCell(CucumberScenarioResult[] array, DataDimension[] filters, Matcher[] matchers) {
        BreakdownStats stats = new BreakdownStats();
        Valuator valuator = VALUATORS_MAP.get((Object)this.getCell());
        if (filters != null && filters.length > 0) {
            for (DataDimension filter : filters) {
                stats.add(valuator.valuate(array, filter.getExpression(), matchers));
            }
        } else {
            stats.add(valuator.valuate(array, "(.*)", matchers));
        }
        return stats;
    }

    public BreakdownStats[][] valuate(CucumberScenarioResult[] array) {
        DataDimension[][] rowData = this.getRows().expand();
        DataDimension[][] colData = this.getCols().expand();
        BreakdownStats[][] stats = new BreakdownStats[rowData.length][colData.length];
        for (int i = 0; i < rowData.length; ++i) {
            for (int j = 0; j < colData.length; ++j) {
                CucumberScenarioResult[] filteredData = this.filter(array, rowData[i]);
                filteredData = this.filter(filteredData, colData[j]);
                Object[] stepFilters = new DataDimension[]{};
                Matcher[] matchers = new Matcher[]{};
                if (colData[j][colData[j].length - 1].getDimensionValue().isStep()) {
                    stepFilters = (DataDimension[])ArrayUtils.add((Object[])stepFilters, (Object)colData[j][colData[j].length - 1]);
                }
                if (stepFilters.length <= 0 && rowData[i][rowData[i].length - 1].getDimensionValue().isStep()) {
                    stepFilters = (DataDimension[])ArrayUtils.add((Object[])stepFilters, (Object)rowData[i][rowData[i].length - 1]);
                }
                stats[i][j] = this.valuateCell(filteredData, (DataDimension[])stepFilters, matchers);
            }
        }
        return stats;
    }
}

