/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.runner;

import com.github.mkolisnyk.cucumber.runner.ExtendedCucumberBackground;
import cucumber.runtime.Runtime;
import cucumber.runtime.model.CucumberBackground;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.CucumberScenario;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.BasicStatement;
import gherkin.formatter.model.Row;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.Step;
import java.util.Set;

public class ExtendedCucumberScenario
extends CucumberScenario {
    private final ExtendedCucumberBackground cucumberBackground;
    private final Scenario scenario;
    private final CucumberFeature cucumberFeature;
    private final BasicStatement statement;

    public ExtendedCucumberScenario(CucumberFeature cucumberFeatureValue, ExtendedCucumberBackground cucumberBackgroundValue, Scenario scenarioValue) {
        super(cucumberFeatureValue, (CucumberBackground)cucumberBackgroundValue, scenarioValue);
        this.cucumberFeature = cucumberFeatureValue;
        this.cucumberBackground = cucumberBackgroundValue;
        this.scenario = scenarioValue;
        this.statement = scenarioValue;
    }

    public ExtendedCucumberScenario(CucumberFeature cucumberFeatureValue, ExtendedCucumberBackground cucumberBackgroundValue, Scenario exampleScenario, Row example) {
        super(cucumberFeatureValue, (CucumberBackground)cucumberBackgroundValue, exampleScenario, example);
        this.cucumberFeature = cucumberFeatureValue;
        this.cucumberBackground = cucumberBackgroundValue;
        this.scenario = exampleScenario;
        this.statement = exampleScenario;
    }

    public void run(Formatter formatter, Reporter reporter, Runtime runtime) {
        Set tags = this.tagsAndInheritedTags();
        runtime.buildBackendWorlds(reporter, tags, this.scenario);
        try {
            formatter.startOfScenarioLifeCycle((Scenario)this.getGherkinModel());
        }
        catch (Throwable ignore) {
            System.out.println("Ignore");
        }
        runtime.runBeforeHooks(reporter, tags);
        this.runBackground(formatter, reporter, runtime);
        this.format(formatter);
        this.runSteps(reporter, runtime);
        runtime.runAfterHooks(reporter, tags);
        try {
            formatter.endOfScenarioLifeCycle((Scenario)this.getGherkinModel());
        }
        catch (Throwable ignore) {
            System.out.println("Ignore");
        }
    }

    private String createScenarioDesignation() {
        return this.cucumberFeature.getPath() + ":" + Integer.toString(this.scenario.getLine()) + " # " + this.scenario.getKeyword() + ": " + this.scenario.getName();
    }

    private void runBackground(Formatter formatter, Reporter reporter, Runtime runtime) {
        if (this.cucumberBackground != null) {
            this.cucumberBackground.format(formatter);
            this.cucumberBackground.runSteps(reporter, runtime);
        }
    }

    public void format(Formatter formatter) {
        this.statement.replay(formatter);
        for (Step step : this.getSteps()) {
            formatter.step(step);
        }
    }

    public void runSteps(Reporter reporter, Runtime runtime) {
        for (Step step : this.getSteps()) {
            this.runStep(step, reporter, runtime);
        }
    }

    public void runStep(Step step, Reporter reporter, Runtime runtime) {
        runtime.runStep(this.cucumberFeature.getPath(), step, reporter, this.cucumberFeature.getI18n());
    }
}

