/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting;

import com.github.mkolisnyk.cucumber.reporting.CucumberResultsOverview;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportLink;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportTypes;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberFeatureResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberScenarioResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberStepResult;
import com.github.mkolisnyk.cucumber.reporting.utils.drawers.PieChartDrawer;
import com.github.mkolisnyk.cucumber.runner.runtime.ExtendedRuntimeOptions;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class CucumberCoverageOverview
extends CucumberResultsOverview {
    private String[] includeCoverageTags = new String[0];
    private String[] excludeCoverageTags = new String[0];

    public CucumberCoverageOverview() {
    }

    public CucumberCoverageOverview(ExtendedRuntimeOptions extendedOptions) {
        super(extendedOptions);
        this.setExcludeCoverageTags(extendedOptions.getExcludeCoverageTags());
        this.setIncludeCoverageTags(extendedOptions.getIncludeCoverageTags());
    }

    public final String[] getIncludeCoverageTags() {
        return this.includeCoverageTags;
    }

    public final void setIncludeCoverageTags(String[] includeCoverageTagsValue) {
        this.includeCoverageTags = includeCoverageTagsValue == null ? new String[0] : includeCoverageTagsValue;
    }

    public final String[] getExcludeCoverageTags() {
        return this.excludeCoverageTags;
    }

    public final void setExcludeCoverageTags(String[] excludeCoverageTagsValue) {
        this.excludeCoverageTags = excludeCoverageTagsValue == null ? new String[0] : excludeCoverageTagsValue;
    }

    private String getFeatureStatus(CucumberFeatureResult result) {
        if (result.getStatus().equals("undefined") || result.getUndefined() > 0) {
            return "undefined";
        }
        return "passed";
    }

    private String getScenarioStatus(CucumberScenarioResult result) {
        if (result.getStatus().equals("undefined") || result.getUndefined() > 0) {
            return "undefined";
        }
        return "passed";
    }

    @Override
    public int[][] getStatuses(CucumberFeatureResult[] results) {
        int[][] statuses = new int[][]{{0, 0}, {0, 0}, {0, 0}};
        for (CucumberFeatureResult result : results) {
            result.setIncludeCoverageTags(this.includeCoverageTags);
            result.setExcludeCoverageTags(this.excludeCoverageTags);
            if (result.getStatus().equals("undefined") || result.getUndefined() > 0) {
                int[] nArray = statuses[0];
                nArray[1] = nArray[1] + 1;
            } else {
                int[] nArray = statuses[0];
                nArray[0] = nArray[0] + 1;
            }
            for (CucumberScenarioResult element : result.getElements()) {
                element.setIncludeCoverageTags(this.includeCoverageTags);
                element.setExcludeCoverageTags(this.excludeCoverageTags);
                if (element.getStatus().equals("undefined") || element.getUndefined() > 0) {
                    int[] nArray = statuses[1];
                    nArray[1] = nArray[1] + 1;
                } else {
                    int[] nArray = statuses[1];
                    nArray[0] = nArray[0] + 1;
                }
                for (CucumberStepResult step : element.getSteps()) {
                    if (step.getResult().getStatus().equals("undefined")) {
                        int[] nArray = statuses[2];
                        nArray[1] = nArray[1] + 1;
                        continue;
                    }
                    int[] nArray = statuses[2];
                    nArray[0] = nArray[0] + 1;
                }
            }
        }
        return statuses;
    }

    @Override
    protected String generateFeatureOverview(CucumberFeatureResult[] results) throws IOException {
        String content = this.getReportBase();
        content = content.replaceAll("__TITLE__", "Test Coverage Overview");
        String reportContent = "";
        reportContent = reportContent + "<h1>Features Status</h1><table><tr><th rowspan=\"2\">Feature Name</th><th rowspan=\"2\">Status</th><th colspan=\"2\">Scenarios</th><th rowspan=\"2\">Tags</th></tr><tr><th>Covered</th><th>Not Covered</th></tr>";
        for (CucumberFeatureResult cucumberFeatureResult : results) {
            cucumberFeatureResult.setIncludeCoverageTags(this.includeCoverageTags);
            cucumberFeatureResult.setExcludeCoverageTags(this.excludeCoverageTags);
            String status = this.getFeatureStatus(cucumberFeatureResult);
            reportContent = reportContent + String.format(Locale.US, "<tr class=\"%s\"><td>%s</td><td>%s</td><td>%d</td><td>%d</td><td>%s</td></tr>", status, cucumberFeatureResult.getName(), status, cucumberFeatureResult.getPassed() + cucumberFeatureResult.getFailed() + cucumberFeatureResult.getSkipped(), cucumberFeatureResult.getUndefined(), StringUtils.join((Object[])cucumberFeatureResult.getAllTags(true), (String)", "));
        }
        reportContent = reportContent + "</table>";
        reportContent = reportContent + "<h1>Scenario Status</h1><table><tr><th rowspan=\"2\">Feature Name</th><th rowspan=\"2\">Scenario</th><th rowspan=\"2\">Status</th><th colspan=\"2\">Steps</th><th rowspan=\"2\">Tags</th></tr><tr><th>Covered</th><th>Not Covered</th></tr>";
        int[][] statuses = this.getStatuses(results);
        int[] featureStatuses = statuses[0];
        int[] scenarioStatuses = statuses[1];
        for (CucumberFeatureResult result : results) {
            result.setIncludeCoverageTags(this.includeCoverageTags);
            result.setExcludeCoverageTags(this.excludeCoverageTags);
            for (CucumberScenarioResult element : result.getElements()) {
                element.setIncludeCoverageTags(this.includeCoverageTags);
                element.setExcludeCoverageTags(this.excludeCoverageTags);
                String status = this.getScenarioStatus(element);
                HashSet<String> tags = new HashSet<String>();
                for (String tag : result.getAllTags(false)) {
                    tags.add(tag);
                }
                for (String tag : element.getAllTags()) {
                    if (tags.contains(tag)) continue;
                    tags.add(tag);
                }
                reportContent = reportContent + String.format(Locale.US, "<tr class=\"%s\"><td>%s</td><td>%s</td><td>%s</td><td>%d</td><td>%d</td><td>%s</td></tr>", status, result.getName(), element.getName(), status, element.getPassed() + element.getFailed() + element.getSkipped(), element.getUndefined(), StringUtils.join(tags, (String)", "));
            }
            reportContent = reportContent + "<tr><td colspan=\"6\"></td></tr>";
        }
        reportContent = reportContent + "</table>";
        content = content.replaceAll("__REPORT__", reportContent);
        PieChartDrawer pieChartDrawer = new PieChartDrawer();
        content = content.replaceAll("__FEATURE_DATA__", pieChartDrawer.generatePieChart(450, 300, featureStatuses, new String[]{"Covered", "Not Covered"}, new String[]{"green", "gold"}, new String[]{"darkgreen", "GoldenRod"}, 20, 2));
        content = content.replaceAll("__SCENARIO_DATA__", pieChartDrawer.generatePieChart(450, 300, scenarioStatuses, new String[]{"Covered", "Not Covered"}, new String[]{"green", "gold"}, new String[]{"darkgreen", "GoldenRod"}, 20, 2));
        return content;
    }

    @Override
    public void execute(boolean toPDF) throws Exception {
        this.executeOverviewReport("coverage", toPDF);
    }

    @Override
    public void execute() throws Exception {
        this.executeOverviewReport("coverage");
    }

    @Override
    public CucumberReportTypes getReportType() {
        return CucumberReportTypes.COVERAGE_OVERVIEW;
    }

    @Override
    public CucumberReportLink getReportDocLink() {
        return CucumberReportLink.COVERAGE_OVERVIEW_URL;
    }
}

