/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting;

import com.github.mkolisnyk.cucumber.reporting.interfaces.KECompatibleReport;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportLink;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportTypes;
import com.github.mkolisnyk.cucumber.reporting.types.knownerrors.KnownErrorsModel;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberBeforeAfterResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberEmbedding;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberFeatureResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberScenarioResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberStepResult;
import com.github.mkolisnyk.cucumber.reporting.utils.helpers.StringConversionUtils;
import com.github.mkolisnyk.cucumber.runner.runtime.ExtendedRuntimeOptions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class CucumberDetailedResults
extends KECompatibleReport {
    private String screenShotLocation;
    private String screenShotWidth;

    public CucumberDetailedResults() {
    }

    public CucumberDetailedResults(ExtendedRuntimeOptions extendedOptions) {
        super(extendedOptions);
        this.setScreenShotLocation(extendedOptions.getScreenShotLocation());
        this.setScreenShotWidth(extendedOptions.getScreenShotSize());
    }

    public final String getScreenShotLocation() {
        return this.screenShotLocation;
    }

    public final void setScreenShotLocation(String screenShotLocationValue) {
        this.screenShotLocation = screenShotLocationValue;
    }

    public final String getScreenShotWidth() {
        return this.screenShotWidth;
    }

    public final void setScreenShotWidth(String screenShotWidthValue) {
        this.screenShotWidth = screenShotWidthValue;
    }

    private String getReportBase() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/results-report-tmpl.html");
        String result = IOUtils.toString((InputStream)is);
        return result;
    }

    private String escapeHtml(String input) {
        return StringEscapeUtils.escapeHtml((String)input);
    }

    public OverviewStats valuateOverviewStats(CucumberFeatureResult[] results) {
        OverviewStats stats = new OverviewStats();
        for (CucumberFeatureResult result : results) {
            result.valuate();
            stats.addOverallDuration(result.getDuration());
            if (result.getStatus().equals("passed")) {
                stats.addFeaturesPassed(1);
            } else if (result.getStatus().equals("failed")) {
                stats.addFeaturesFailed(1);
            } else if (result.getStatus().equals("known")) {
                stats.addFeaturesKnown(1);
            } else {
                stats.addFeaturesUndefined(1);
            }
            stats.addScenariosPassed(result.getPassed());
            stats.addScenariosFailed(result.getFailed());
            stats.addScenariosKnown(result.getKnown());
            stats.addScenariosUndefined(result.getUndefined() + result.getSkipped());
            for (CucumberScenarioResult scenario : result.getElements()) {
                stats.addStepsPassed(scenario.getPassed());
                stats.addStepsFailed(scenario.getFailed());
                stats.addStepsKnown(scenario.getKnown());
                stats.addStepsUndefined(scenario.getUndefined() + scenario.getSkipped());
            }
        }
        return stats;
    }

    private String generateOverview(CucumberFeatureResult[] results) {
        int secondsInMinute = 60;
        int secondsInHour = 3600;
        float highestPercent = 100.0f;
        float overallDuration = 0.0f;
        OverviewStats stats = this.valuateOverviewStats(results);
        overallDuration = stats.getOverallDuration();
        return String.format(Locale.US, "<table><tr><th></th><th>Passed</th><th>Failed</th><th>Known</th><th>Undefined</th><th>%%Passed</th></tr><tr><th>Features</th><td class=\"passed\">%d</td><td class=\"failed\">%d</td><td class=\"known\">%d</td><td class=\"undefined\">%d</td><td>%.2f</td></tr><tr><th>Scenarios</th><td class=\"passed\">%d</td><td class=\"failed\">%d</td><td class=\"known\">%d</td><td class=\"undefined\">%d</td><td>%.2f</td></tr><tr><th>Steps</th><td class=\"passed\">%d</td><td class=\"failed\">%d</td><td class=\"known\">%d</td><td class=\"undefined\">%d</td><td>%.2f</td></tr></table><div><b>Overall Duration: %dh %02dm %02ds</b></div>", stats.getFeaturesPassed(), stats.getFeaturesFailed(), stats.getFeaturesKnown(), stats.getFeaturesUndefined(), Float.valueOf(100.0f * (float)(stats.getFeaturesPassed() + stats.getFeaturesKnown()) / (float)(stats.getFeaturesPassed() + stats.getFeaturesKnown() + stats.getFeaturesFailed() + stats.getFeaturesUndefined())), stats.getScenariosPassed(), stats.getScenariosFailed(), stats.getScenariosKnown(), stats.getScenariosUndefined(), Float.valueOf(100.0f * (float)(stats.getScenariosPassed() + stats.getScenariosKnown()) / (float)(stats.getScenariosPassed() + stats.getScenariosKnown() + stats.getScenariosFailed() + stats.getScenariosUndefined())), stats.getStepsPassed(), stats.getStepsFailed(), stats.getStepsKnown(), stats.getStepsUndefined(), Float.valueOf(100.0f * (float)(stats.getStepsPassed() + stats.getStepsKnown()) / (float)(stats.getStepsPassed() + stats.getStepsKnown() + stats.getStepsFailed() + stats.getStepsUndefined())), (int)overallDuration / 3600, (int)overallDuration % 3600 / 60, (int)overallDuration % 3600 % 60);
    }

    private String generateNameFromId(String scId) {
        String result = scId.replaceAll("[; !@#$%^&*()+=]", "_");
        return result;
    }

    private String generateTableOfContents(CucumberFeatureResult[] results) {
        String reportContent = "";
        reportContent = reportContent + "<a id=\"top\"></a><h1>Table of Contents</h1><ol>";
        for (CucumberFeatureResult result : results) {
            reportContent = reportContent + String.format(Locale.US, "<li> <span class=\"%s\"><a href=\"#feature-%s\">%s</a></span><ol>", result.getStatus(), this.escapeHtml(result.getId()), this.escapeHtml(result.getName()));
            for (CucumberScenarioResult scenario : result.getElements()) {
                if (!scenario.getKeyword().contains("Scenario")) continue;
                reportContent = reportContent + String.format(Locale.US, "<li> <span class=\"%s\"><a href=\"#sc-%s\">%s</a></span></li>", scenario.getStatus(), this.escapeHtml(scenario.getId()), this.escapeHtml(scenario.getName()));
            }
            reportContent = reportContent + "</ol></li>";
        }
        reportContent = reportContent + "</ol>";
        return reportContent;
    }

    private String generateStepRows(CucumberStepResult step) {
        String reportContent = "";
        if (step.getRows() != null) {
            reportContent = reportContent + String.format(Locale.US, "<tr class=\"%s\"><td style=\"padding-left:20px\" colspan=\"2\"><table>", step.getResult().getStatus());
            for (int i = 0; i < step.getRows().length; ++i) {
                reportContent = reportContent + "<tr>";
                for (int j = 0; j < step.getRows()[i].length; ++j) {
                    reportContent = reportContent + String.format(Locale.US, "<td>%s</td>", this.escapeHtml(step.getRows()[i][j]));
                }
                reportContent = reportContent + "</tr>";
            }
            reportContent = reportContent + "</table></td></tr>";
        }
        return reportContent;
    }

    private String generateDocString(CucumberStepResult step) {
        String reportContent = "";
        if (StringUtils.isNotBlank((String)step.getDocString())) {
            reportContent = reportContent + String.format(Locale.US, "<tr class=\"%s_description\"><td style=\"padding-left:20px\" colspan=\"2\">", step.getResult().getStatus());
            reportContent = reportContent + String.format(Locale.US, "<br>%s</br>", this.escapeHtml(step.getDocString()).replaceAll("\n", "</br><br>"));
            reportContent = reportContent + "</td></tr>";
        }
        return reportContent;
    }

    private String getExtensionFromMime(String mime) {
        if (mime.contains("png")) {
            return "png";
        }
        if (mime.contains("jpg") || mime.contains("jpeg")) {
            return "jpg";
        }
        return "txt";
    }

    private String embeddingScreenShots(CucumberScenarioResult scenario, CucumberStepResult step) throws IOException {
        String reportContent = "";
        String scenarioId = scenario.getId();
        if (StringUtils.isBlank((String)scenarioId)) {
            scenarioId = "background";
        }
        if (step.getEmbeddings() != null) {
            int index = 0;
            long base = new Date().getTime();
            for (CucumberEmbedding embedding : step.getEmbeddings()) {
                String embedPath = this.getScreenShotLocation() + this.generateNameFromId(scenarioId) + (base + (long)index) + "." + this.getExtensionFromMime(embedding.getMimeType());
                File embedShot = new File(this.getOutputDirectory() + embedPath);
                FileUtils.writeByteArrayToFile((File)embedShot, (byte[])embedding.getData());
                String widthString = "";
                if (StringUtils.isNotBlank((String)this.getScreenShotWidth())) {
                    widthString = String.format(Locale.US, "width=\"%s\"", this.getScreenShotWidth());
                }
                reportContent = reportContent + String.format(Locale.US, "<tr class=\"%s\"><td colspan=\"2\"><img src=\"%s\" %s /></td></tr>", step.getResult().getStatus(), embedPath, widthString);
                ++index;
            }
        }
        return reportContent;
    }

    private String embeddingOutput(CucumberStepResult step) {
        String reportContent = "";
        if (step.getOutput() != null) {
            reportContent = reportContent + String.format(Locale.US, "<tr class=\"%s\"><td colspan=\"2\" class=\"comment\"><span class=\"tip\">Output</span><pre class=\"comment\">", step.getResult().getStatus());
            for (String line : step.getOutput()) {
                reportContent = reportContent + line + System.lineSeparator();
            }
            reportContent = reportContent + String.format(Locale.US, "</pre></td></tr>", new Object[0]);
        }
        return reportContent;
    }

    private String generateScreenShot(CucumberScenarioResult scenario, CucumberStepResult step) throws IOException {
        String reportContent = "";
        if (step.getResult().getStatus().trim().equalsIgnoreCase("failed")) {
            reportContent = reportContent + String.format(Locale.US, "<tr class=\"%s\"><td colspan=\"2\"><div>%s%s</br></div></td></tr>", step.getResult().getStatus(), "<br>", this.escapeHtml(step.getResult().getErrorMessage()).replaceAll(System.lineSeparator(), "</br><br>" + System.lineSeparator()));
            String scenarioId = scenario.getId();
            if (StringUtils.isBlank((String)scenarioId)) {
                scenarioId = "background";
            }
            String filePath = this.getScreenShotLocation() + this.generateNameFromId(scenarioId) + ".png";
            File shot = new File(this.getOutputDirectory() + filePath);
            if (shot.exists()) {
                String widthString = "";
                if (StringUtils.isNotBlank((String)this.getScreenShotWidth())) {
                    widthString = String.format(Locale.US, "width=\"%s\"", this.getScreenShotWidth());
                }
                reportContent = reportContent + String.format(Locale.US, "<tr class=\"%s\"><td colspan=\"2\"><img src=\"%s\" %s /></td></tr>", step.getResult().getStatus(), filePath, widthString);
            }
        }
        return reportContent;
    }

    private String generateBeforeAfterRow(CucumberBeforeAfterResult results, String name) {
        if (results != null) {
            String error = this.escapeHtml(results.getResult().getErrorMessage());
            error = StringUtils.isBlank((String)error) ? "" : "<br>" + error.replaceAll(System.lineSeparator(), "</br><br>") + "</br>";
            return String.format(Locale.US, "<tr class=\"%s\"><td>%s</td><td colspan=\"2\"></td><td width=\"100\">%s</td></tr><tr class=\"%s\"><td colspan=\"4\">%s</td></tr>", results.getResult().getStatus(), name, results.getResult().getDurationTimeString("HH:mm:ss:S"), results.getResult().getStatus(), error);
        }
        return "";
    }

    private String generateStepsReport(CucumberFeatureResult[] results) throws IOException {
        String content = this.getReportBase();
        content = content.replaceAll("__TITLE__", "Detailed Results Report");
        content = content.replaceAll("__OVERVIEW__", this.generateOverview(results));
        String reportContent = "";
        reportContent = reportContent + this.generateTableOfContents(results);
        reportContent = reportContent + "<h1>Detailed Results Report</h1><table width=\"700px\">";
        for (CucumberFeatureResult result : results) {
            String featureDescriptionHeading = "";
            if (StringUtils.isNotBlank((String)result.getDescription())) {
                featureDescriptionHeading = String.format(Locale.US, "<tr class=\"%s_description\"><td colspan=\"4\"><br>%s</br></td></tr>", result.getStatus(), this.escapeHtml(result.getDescription()).replaceAll(System.lineSeparator(), "</br><br>" + System.lineSeparator()));
            }
            reportContent = reportContent + String.format(Locale.US, "<tr class=\"%s\"><td colspan=\"4\"><b>Feature:</b> <a id=\"feature-%s\">%s</a></td></tr>%s<tr class=\"%s\"><td><small><b>Passed:</b> %d</small></td><td><small><b>Failed:</b> %d</small></td><td><small><b>Undefined:</b> %d</small></td><td><small>Duration: %.2fs</small></td></tr><tr class=\"%s\"><td colspan=\"4\" style=\"padding-left:20px\"> <table width=\"100%%\">", result.getStatus(), this.escapeHtml(result.getId()), this.escapeHtml(result.getName()), featureDescriptionHeading, result.getStatus(), result.getPassed(), result.getFailed(), result.getUndefined() + result.getSkipped(), Float.valueOf(result.getDuration()), result.getStatus());
            for (CucumberScenarioResult scenario : result.getElements()) {
                String descriptionHeading = "";
                if (StringUtils.isNotBlank((String)scenario.getDescription())) {
                    descriptionHeading = String.format(Locale.US, "<tr class=\"%s_description\"><td colspan=\"4\"><br>%s</br></td></tr>", scenario.getStatus(), this.escapeHtml(scenario.getDescription()).replaceAll(System.lineSeparator(), "</br><br>" + System.lineSeparator()));
                }
                reportContent = reportContent + String.format(Locale.US, "<tr class=\"%s\"><td colspan=\"4\"><b>%s:</b> <a id=\"sc-%s\">%s</a></td></tr>%s<tr class=\"%s\"><td><small><b>Passed:</b> %d</small></td><td><small><b>Failed:</b> %d</small></td><td><small><b>Undefined:</b> %d</small></td><td><small>Duration: %.2fs</small></td></tr>%s<tr class=\"%s\"><td colspan=\"4\" style=\"padding-left:20px\"> <table width=\"100%%\">", scenario.getStatus(), scenario.getKeyword(), this.escapeHtml(scenario.getId()), this.escapeHtml(scenario.getName()), descriptionHeading, scenario.getStatus(), scenario.getPassed(), scenario.getFailed(), scenario.getUndefined() + scenario.getSkipped(), scenario.getDuration(), this.generateBeforeAfterRow(scenario.getBefore(), "Before"), scenario.getStatus());
                for (CucumberStepResult step : scenario.getSteps()) {
                    reportContent = reportContent + String.format(Locale.US, "<tr class=\"%s\"><td><b>%s</b> %s</td><td width=\"100\">%s</td></tr>", step.getResult().getStatus(), step.getKeyword(), this.escapeHtml(step.getName()), step.getResult().getDurationTimeString("HH:mm:ss:S"));
                    reportContent = reportContent + this.generateStepRows(step);
                    reportContent = reportContent + this.generateDocString(step);
                    reportContent = reportContent + this.generateScreenShot(scenario, step);
                    reportContent = reportContent + this.embeddingScreenShots(scenario, step);
                    reportContent = reportContent + this.embeddingOutput(step);
                }
                reportContent = reportContent + "</table></td></tr>" + this.generateBeforeAfterRow(scenario.getAfter(), "After") + "<tr><td colspan=\"5\">" + "<sup><a href=\"#top\">Back to Table of Contents</a></sup></td></tr>";
            }
            reportContent = reportContent + "</table></td></tr><tr><td colspan=\"5\"></td></tr>";
        }
        reportContent = reportContent + "</table>";
        reportContent = StringConversionUtils.replaceHtmlEntitiesWithCodes(reportContent);
        reportContent = reportContent.replaceAll("[$]", "&#36;");
        content = content.replaceAll("__REPORT__", reportContent);
        return content;
    }

    @Override
    public int[][] getStatuses(CucumberFeatureResult[] results) {
        return null;
    }

    @Override
    public CucumberReportTypes getReportType() {
        return CucumberReportTypes.DETAILED_REPORT;
    }

    @Override
    public void validateParameters() {
    }

    @Override
    public CucumberReportLink getReportDocLink() {
        return CucumberReportLink.DETAILED_URL;
    }

    @Override
    public void execute(boolean aggregate, boolean toPDF) throws Exception {
        this.execute((KnownErrorsModel)null, aggregate, toPDF);
    }

    @Override
    public void execute(KnownErrorsModel batch, boolean aggregate, boolean toPDF) throws Exception {
        CucumberFeatureResult[] features = this.readFileContent(aggregate);
        String formatName = "";
        if (batch != null) {
            for (CucumberFeatureResult feature : features) {
                feature.valuateKnownErrors(batch);
            }
        }
        formatName = aggregate ? "%s%s%s-agg-test-results.html" : "%s%s%s-test-results.html";
        File outFile = new File(String.format(Locale.US, formatName, this.getOutputDirectory(), File.separator, this.getOutputName()));
        String content = this.generateStepsReport(features);
        FileUtils.writeStringToFile((File)outFile, (String)content, (String)"UTF-8");
        if (toPDF) {
            this.exportToPDF(outFile, "test-results");
        }
    }

    public class OverviewStats {
        private int featuresPassed = 0;
        private int featuresFailed = 0;
        private int featuresKnown = 0;
        private int featuresUndefined = 0;
        private int scenariosPassed = 0;
        private int scenariosFailed = 0;
        private int scenariosKnown = 0;
        private int scenariosUndefined = 0;
        private int stepsPassed = 0;
        private int stepsFailed = 0;
        private int stepsKnown = 0;
        private int stepsUndefined = 0;
        private float overallDuration = 0.0f;

        public final int getFeaturesPassed() {
            return this.featuresPassed;
        }

        public final int getFeaturesFailed() {
            return this.featuresFailed;
        }

        public final int getFeaturesUndefined() {
            return this.featuresUndefined;
        }

        public final int getScenariosPassed() {
            return this.scenariosPassed;
        }

        public final int getScenariosFailed() {
            return this.scenariosFailed;
        }

        public final int getScenariosUndefined() {
            return this.scenariosUndefined;
        }

        public final int getStepsPassed() {
            return this.stepsPassed;
        }

        public final int getStepsFailed() {
            return this.stepsFailed;
        }

        public final int getStepsUndefined() {
            return this.stepsUndefined;
        }

        public final float getOverallDuration() {
            return this.overallDuration;
        }

        public int getFeaturesKnown() {
            return this.featuresKnown;
        }

        public int getScenariosKnown() {
            return this.scenariosKnown;
        }

        public int getStepsKnown() {
            return this.stepsKnown;
        }

        public final void addFeaturesPassed(int featuresPassedValue) {
            this.featuresPassed += featuresPassedValue;
        }

        public final void addFeaturesFailed(int featuresFailedValue) {
            this.featuresFailed += featuresFailedValue;
        }

        public final void addFeaturesUndefined(int featuresUndefinedValue) {
            this.featuresUndefined += featuresUndefinedValue;
        }

        public final void addScenariosPassed(int scenariosPassedValue) {
            this.scenariosPassed += scenariosPassedValue;
        }

        public final void addScenariosFailed(int scenariosFailedValue) {
            this.scenariosFailed += scenariosFailedValue;
        }

        public final void addScenariosUndefined(int scenariosUndefinedValue) {
            this.scenariosUndefined += scenariosUndefinedValue;
        }

        public final void addStepsPassed(int stepsPassedValue) {
            this.stepsPassed += stepsPassedValue;
        }

        public final void addStepsFailed(int stepsFailedValue) {
            this.stepsFailed += stepsFailedValue;
        }

        public final void addStepsUndefined(int stepsUndefinedValue) {
            this.stepsUndefined += stepsUndefinedValue;
        }

        public final void addOverallDuration(float overallDurationValue) {
            this.overallDuration += overallDurationValue;
        }

        public void addFeaturesKnown(int featuresKnownValue) {
            this.featuresKnown += featuresKnownValue;
        }

        public void addScenariosKnown(int scenariosKnownValue) {
            this.scenariosKnown += scenariosKnownValue;
        }

        public void addStepsKnown(int stepsKnownValue) {
            this.stepsKnown += stepsKnownValue;
        }
    }
}

