/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.runner;

import com.github.mkolisnyk.cucumber.reporting.utils.helpers.FolderUtils;
import com.github.mkolisnyk.cucumber.runner.AfterSuite;
import com.github.mkolisnyk.cucumber.runner.BeforeSuite;
import com.github.mkolisnyk.cucumber.runner.ExtendedCucumber;
import com.github.mkolisnyk.cucumber.runner.ExtendedCucumberOptions;
import com.github.mkolisnyk.cucumber.runner.ReportRunner;
import com.github.mkolisnyk.cucumber.runner.parallel.CucumberRunnerThread;
import com.github.mkolisnyk.cucumber.runner.parallel.CucumberRunnerThreadPool;
import com.github.mkolisnyk.cucumber.runner.runtime.ExtendedRuntimeOptions;
import cucumber.api.CucumberOptions;
import cucumber.api.SnippetType;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javassist.ClassPool;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;

public class ExtendedParallelCucumber
extends ParentRunner<Runner> {
    private Class<?> clazz;
    private ExtendedCucumberOptions[] options;
    private CucumberOptions cucumberOption;
    private int threadsCount = 1;
    private ExtendedCucumber[] runners;

    public static int getThreadsCount(int threadsCountNumber, String threadsCountValue) {
        if (StringUtils.isBlank((CharSequence)threadsCountValue)) {
            return threadsCountNumber;
        }
        if (threadsCountValue.matches("(\\d+)")) {
            return Integer.valueOf(threadsCountValue);
        }
        if (System.getProperties().containsKey(threadsCountValue) && System.getProperty(threadsCountValue).matches("(\\d+)")) {
            return Integer.valueOf(System.getProperty(threadsCountValue));
        }
        return threadsCountNumber;
    }

    public ExtendedParallelCucumber(Class<?> clazzValue) throws Exception {
        super(clazzValue);
        this.clazz = clazzValue;
        this.options = (ExtendedCucumberOptions[])this.clazz.getAnnotationsByType(ExtendedCucumberOptions.class);
        this.cucumberOption = this.clazz.getAnnotation(CucumberOptions.class);
        for (ExtendedCucumberOptions option : this.options) {
            this.threadsCount = Math.max(this.threadsCount, ExtendedParallelCucumber.getThreadsCount(option.threadsCount(), option.threadsCountValue()));
        }
        this.runners = this.buildRunners();
    }

    public ExtendedParallelCucumber(Class<?> clazzValue, CucumberOptions baseOptions, ExtendedCucumberOptions[] extendedOptionsValue) throws Exception {
        super(clazzValue);
        this.clazz = clazzValue;
        this.options = extendedOptionsValue;
        this.cucumberOption = baseOptions;
        for (ExtendedCucumberOptions option : this.options) {
            this.threadsCount = Math.max(this.threadsCount, ExtendedParallelCucumber.getThreadsCount(option.threadsCount(), option.threadsCountValue()));
        }
        this.runners = this.buildRunners();
    }

    private ExtendedCucumber[] buildRunners() throws Exception {
        CucumberOptions[] cucumberOptions = this.splitCucumberOption(this.cucumberOption);
        ExtendedCucumberOptions[][] extendedOptions = this.splitExtendedCucumberOptions(this.options, cucumberOptions.length);
        return this.generateTestClasses(cucumberOptions, extendedOptions);
    }

    public final ExtendedCucumber[] getRunners() {
        return this.runners;
    }

    private MemberValue getArrayMemberValue(Object object, Method field, ConstPool cp) throws Exception {
        if (field.getReturnType().getComponentType().equals(String.class)) {
            ArrayMemberValue array = new ArrayMemberValue((MemberValue)new StringMemberValue(cp), cp);
            String[] annoValues = (String[])field.invoke(object, new Object[0]);
            StringMemberValue[] values = new StringMemberValue[annoValues.length];
            for (int i = 0; i < annoValues.length; ++i) {
                values[i] = new StringMemberValue(annoValues[i], cp);
            }
            array.setValue((MemberValue[])values);
            return array;
        }
        ArrayMemberValue array = new ArrayMemberValue((MemberValue)new StringMemberValue(cp), cp);
        return array;
    }

    private MemberValue getFieldMemberValue(Object object, Method field) throws Exception {
        ConstPool cp = new ConstPool(((Object)((Object)this)).getClass().getCanonicalName());
        if (field.getReturnType().isArray()) {
            return this.getArrayMemberValue(object, field, cp);
        }
        if (field.getReturnType().equals(Boolean.TYPE)) {
            return new BooleanMemberValue(((Boolean)field.invoke(object, new Object[0])).booleanValue(), cp);
        }
        if (field.getReturnType().equals(String.class)) {
            return new StringMemberValue((String)field.invoke(object, new Object[0]), cp);
        }
        if (field.getReturnType().equals(Integer.TYPE)) {
            return new IntegerMemberValue(cp, ((Integer)field.invoke(object, new Object[0])).intValue());
        }
        return null;
    }

    public String[] convertPluginPaths(String[] original, int index) {
        String[] result = new String[original.length];
        for (int i = 0; i < original.length; ++i) {
            File path = new File(original[i].replaceFirst("^(usage|junit|json|html|pretty):", ""));
            String name = path.getName();
            String location = path.getParent();
            result[i] = location + "/" + index + "/" + name;
            if (!original[i].matches("^(usage|junit|json|html|pretty):(.*)$")) continue;
            result[i] = original[i].replaceFirst("^(usage|junit|json|html|pretty):(.*)$", "$1:" + result[i]);
        }
        return result;
    }

    public CucumberOptions[] splitCucumberOption(CucumberOptions option) throws Exception {
        CucumberOptions[] result = new CucumberOptions[]{};
        String[] featurePaths = option.features();
        Object[] featureFiles = new String[]{};
        for (String featurePath : featurePaths) {
            File feature = new File(featurePath);
            featureFiles = feature.isDirectory() ? (String[])ArrayUtils.addAll((Object[])featureFiles, (Object[])FolderUtils.getFilesByMask((String)feature.getAbsolutePath(), (String)"(.*).feature")) : (String[])ArrayUtils.add((Object[])featureFiles, (Object)feature.getAbsolutePath());
        }
        int index = 0;
        result = new CucumberOptions[featureFiles.length];
        for (Object file : featureFiles) {
            ConstPool cp = new ConstPool(ExtendedParallelCucumber.class.getCanonicalName());
            javassist.bytecode.annotation.Annotation anno = new javassist.bytecode.annotation.Annotation(CucumberOptions.class.getCanonicalName(), cp);
            for (Method field : CucumberOptions.class.getDeclaredMethods()) {
                EnumMemberValue value;
                String name = field.getName();
                if (name.equals("features")) {
                    ArrayMemberValue array = new ArrayMemberValue((MemberValue)new StringMemberValue(cp), cp);
                    array.setValue((MemberValue[])new StringMemberValue[]{new StringMemberValue((String)file, cp)});
                    anno.addMemberValue(name, (MemberValue)array);
                    continue;
                }
                if (name.equals("plugin")) {
                    String[] plugin = this.convertPluginPaths(option.plugin(), index);
                    ArrayMemberValue array = new ArrayMemberValue((MemberValue)new StringMemberValue(cp), cp);
                    StringMemberValue[] values = new StringMemberValue[plugin.length];
                    for (int i = 0; i < plugin.length; ++i) {
                        values[i] = new StringMemberValue(plugin[i], cp);
                    }
                    array.setValue((MemberValue[])values);
                    anno.addMemberValue(name, (MemberValue)array);
                    continue;
                }
                if (name.equals("snippets")) {
                    value = new EnumMemberValue(cp);
                    value.setType(SnippetType.class.getCanonicalName());
                    value.setValue(SnippetType.UNDERSCORE.name());
                    anno.addMemberValue(name, (MemberValue)value);
                    continue;
                }
                value = this.getFieldMemberValue(option, field);
                if (value == null) continue;
                anno.addMemberValue(name, (MemberValue)value);
            }
            result[index] = (CucumberOptions)anno.toAnnotationType(((Object)((Object)this)).getClass().getClassLoader(), ClassPool.getDefault());
            ++index;
        }
        return result;
    }

    private ExtendedCucumberOptions generateExtendedOption(ExtendedCucumberOptions extendedOption, ConstPool cp, int i, int j) throws Exception {
        javassist.bytecode.annotation.Annotation anno = new javassist.bytecode.annotation.Annotation(ExtendedCucumberOptions.class.getCanonicalName(), cp);
        for (Method field : ExtendedCucumberOptions.class.getDeclaredMethods()) {
            String name = field.getName();
            if (name.equals("outputFolder")) {
                anno.addMemberValue(name, (MemberValue)new StringMemberValue(extendedOption.outputFolder() + "/" + i + "_" + j, cp));
                continue;
            }
            if (name.equals("jsonReport") || name.equals("jsonUsageReport")) {
                String newName = this.convertPluginPaths(new String[]{(String)field.invoke((Object)extendedOption, new Object[0])}, i)[0];
                anno.addMemberValue(name, (MemberValue)new StringMemberValue(newName, cp));
                continue;
            }
            if (name.equals("jsonReports") || name.equals("jsonUsageReports")) {
                String[] reports = this.convertPluginPaths((String[])field.invoke((Object)extendedOption, new Object[0]), i);
                ArrayMemberValue array = new ArrayMemberValue((MemberValue)new StringMemberValue(cp), cp);
                StringMemberValue[] values = new StringMemberValue[reports.length];
                for (int k = 0; k < reports.length; ++k) {
                    values[k] = new StringMemberValue(reports[k], cp);
                }
                array.setValue((MemberValue[])values);
                anno.addMemberValue(name, (MemberValue)array);
                continue;
            }
            MemberValue value = this.getFieldMemberValue(extendedOption, field);
            if (value == null) continue;
            anno.addMemberValue(name, this.getFieldMemberValue(extendedOption, field));
        }
        return (ExtendedCucumberOptions)anno.toAnnotationType(((Object)((Object)this)).getClass().getClassLoader(), ClassPool.getDefault());
    }

    public ExtendedCucumberOptions[][] splitExtendedCucumberOptions(ExtendedCucumberOptions[] extendedOptions, int suitesCount) throws Exception {
        ExtendedCucumberOptions[][] result = new ExtendedCucumberOptions[suitesCount][extendedOptions.length];
        for (int i = 0; i < suitesCount; ++i) {
            ConstPool cp = new ConstPool(ExtendedParallelCucumber.class.getCanonicalName());
            for (int j = 0; j < extendedOptions.length; ++j) {
                result[i][j] = this.generateExtendedOption(extendedOptions[j], cp, i, j);
            }
        }
        return result;
    }

    public final ExtendedCucumber[] generateTestClasses(CucumberOptions[] cucumberOptions, ExtendedCucumberOptions[][] extendedOptions) throws Exception {
        ExtendedCucumber[] classes = new ExtendedCucumber[cucumberOptions.length];
        for (int i = 0; i < cucumberOptions.length; ++i) {
            classes[i] = new ExtendedCucumber(this.clazz, cucumberOptions[i], extendedOptions[i], false);
        }
        return classes;
    }

    public final String[] getOutputJsonPaths(boolean usage) {
        int i;
        Object[] results = new String[]{};
        String basePath = "";
        String keyword = "json";
        if (usage) {
            keyword = "usage";
        }
        for (String plugin : this.cucumberOption.plugin()) {
            if (!plugin.startsWith(keyword)) continue;
            basePath = plugin.split(":")[1];
        }
        if (StringUtils.isBlank((CharSequence)basePath)) {
            return null;
        }
        results = new String[this.runners.length];
        for (i = 0; i < this.runners.length; ++i) {
            String folder = new File(basePath).getParent();
            String name = new File(basePath).getName();
            results[i] = folder + "/" + i + "/" + name;
        }
        for (i = 0; i < results.length; ++i) {
            if (new File(results[i]).exists()) continue;
            results = (String[])ArrayUtils.remove((Object[])results, (int)i);
            --i;
        }
        return results;
    }

    private void runReports() throws Exception {
        ExtendedRuntimeOptions[] runtimeOptions = new ExtendedRuntimeOptions[this.options.length];
        for (int i = 0; i < runtimeOptions.length; ++i) {
            runtimeOptions[i] = new ExtendedRuntimeOptions(this.options[i]);
            runtimeOptions[i].setJsonReportPaths(this.getOutputJsonPaths(false));
            runtimeOptions[i].setJsonUsageReportPaths(this.getOutputJsonPaths(true));
        }
        for (ExtendedRuntimeOptions option : runtimeOptions) {
            ReportRunner.run((ExtendedRuntimeOptions)option);
        }
    }

    public Description getDescription() {
        return Description.createSuiteDescription(((Object)((Object)this)).getClass());
    }

    private void runPredefinedMethods(Class annotation) throws Exception {
        Method[] methodList;
        if (!annotation.isAnnotation()) {
            return;
        }
        block0: for (Method method : methodList = this.clazz.getMethods()) {
            Annotation[] annotations;
            for (Annotation item : annotations = method.getAnnotations()) {
                if (!item.annotationType().equals(annotation)) continue;
                method.invoke(null, new Object[0]);
                continue block0;
            }
        }
    }

    public void run(RunNotifier notifier) {
        CucumberRunnerThreadPool.setCapacity(this.threadsCount);
        try {
            this.runPredefinedMethods(BeforeSuite.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.run(notifier);
        try {
            CucumberRunnerThreadPool.get().waitEmpty();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            this.runPredefinedMethods(AfterSuite.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.runReports();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int testCount() {
        return this.getRunners().length;
    }

    protected Description describeChild(Runner runner) {
        return runner.getDescription();
    }

    protected void runChild(Runner runner, RunNotifier notifier) {
        ExtendedCucumber cucumber = (ExtendedCucumber)runner;
        if (cucumber.getChildren().size() <= 0) {
            System.out.println("Nothing to run!!!");
            return;
        }
        Thread thread = new Thread(new CucumberRunnerThread(cucumber, notifier));
        try {
            CucumberRunnerThreadPool.get().push(thread);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected List<Runner> getChildren() {
        ArrayList<Runner> children = new ArrayList<Runner>();
        for (ExtendedCucumber runner : this.getRunners()) {
            children.add((Runner)runner);
        }
        return children;
    }
}

