/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.runner;

import com.github.mkolisnyk.cucumber.reporting.CucumberSplitFeature;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberFeatureResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberScenarioResult;
import com.github.mkolisnyk.cucumber.runner.AnnotationInvocationHandler;
import com.github.mkolisnyk.cucumber.runner.ExtendedCucumber;
import com.github.mkolisnyk.cucumber.runner.ExtendedCucumberOptions;
import com.github.mkolisnyk.cucumber.runner.ExtendedParallelCucumber;
import com.github.mkolisnyk.cucumber.runner.ReportRunner;
import com.github.mkolisnyk.cucumber.runner.runtime.ExtendedRuntimeOptions;
import cucumber.api.CucumberOptions;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;

public class ExtendedParallelScenarioCucumber
extends Runner {
    private Class<?> clazz;
    private CucumberOptions cucumberOptions;
    private ExtendedCucumberOptions[] extendedCucumberOptions;

    public ExtendedParallelScenarioCucumber(Class<?> testClass) {
        this.clazz = testClass;
        this.cucumberOptions = testClass.getAnnotation(CucumberOptions.class);
        this.extendedCucumberOptions = (ExtendedCucumberOptions[])testClass.getAnnotationsByType(ExtendedCucumberOptions.class);
    }

    public Description getDescription() {
        return Description.createTestDescription(this.clazz, (String)this.clazz.getCanonicalName());
    }

    public static Annotation setAttrValue(Annotation anno, Class<? extends Annotation> type, String attrName, Object newValue) throws Exception {
        AnnotationInvocationHandler handler = new AnnotationInvocationHandler(anno, attrName, newValue);
        Annotation proxy = (Annotation)Proxy.newProxyInstance(anno.getClass().getClassLoader(), new Class[]{type}, (InvocationHandler)handler);
        return proxy;
    }

    public void run(RunNotifier notifier) {
        try {
            CucumberOptions dryRunOptions = (CucumberOptions)ExtendedParallelScenarioCucumber.setAttrValue((Annotation)this.cucumberOptions, CucumberOptions.class, "dryRun", true);
            ExtendedCucumber cucumber = new ExtendedCucumber(this.clazz, dryRunOptions, this.extendedCucumberOptions, false);
            cucumber.run(notifier);
            String jsonFile = "";
            for (String plugin : this.cucumberOptions.plugin()) {
                if (!plugin.startsWith("json:")) continue;
                jsonFile = plugin.substring("json:".length());
            }
            CucumberSplitFeature report = new CucumberSplitFeature();
            String outputFolder = new File(jsonFile).getParentFile().getAbsolutePath() + File.separator + "features";
            report.setOutputDirectory(outputFolder);
            report.setSourceFile(jsonFile);
            report.execute(true);
            CucumberOptions parallelRunOptions = (CucumberOptions)ExtendedParallelScenarioCucumber.setAttrValue((Annotation)this.cucumberOptions, CucumberOptions.class, "features", new String[]{outputFolder});
            ExtendedParallelCucumber parallelRunner = new ExtendedParallelCucumber(this.clazz, parallelRunOptions, this.extendedCucumberOptions);
            parallelRunner.run(notifier);
            String[] paths = parallelRunner.getOutputJsonPaths(false);
            LinkedHashMap<String, CucumberFeatureResult> featureIdMap = new LinkedHashMap<String, CucumberFeatureResult>();
            for (String path : paths) {
                CucumberFeatureResult[] features;
                for (CucumberFeatureResult feature : features = report.readFileContent(path, true)) {
                    String tag = feature.getTags()[0].getName();
                    if (featureIdMap.containsKey(tag)) {
                        CucumberFeatureResult currentResult = (CucumberFeatureResult)featureIdMap.get(tag);
                        Object[] scenarios = currentResult.getElements();
                        scenarios = (CucumberScenarioResult[])ArrayUtils.addAll((Object[])scenarios, (Object[])feature.getElements());
                        currentResult.setElements((CucumberScenarioResult[])scenarios);
                        featureIdMap.put(tag, currentResult);
                        continue;
                    }
                    featureIdMap.put(tag, feature);
                }
            }
            CucumberFeatureResult[] consolidatedFeatures = new CucumberFeatureResult[featureIdMap.entrySet().size()];
            int index = 0;
            for (Map.Entry entry : featureIdMap.entrySet()) {
                consolidatedFeatures[index] = (CucumberFeatureResult)entry.getValue();
                ++index;
            }
            for (ExtendedCucumberOptions option : this.extendedCucumberOptions) {
                ReportRunner.run((ExtendedRuntimeOptions)new ExtendedRuntimeOptions(option), (CucumberFeatureResult[])consolidatedFeatures);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

