/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.recaptcha.validation;

import com.github.mkopylec.recaptcha.RecaptchaProperties;
import com.github.mkopylec.recaptcha.validation.IpAddressResolver;
import com.github.mkopylec.recaptcha.validation.RecaptchaValidationException;
import com.github.mkopylec.recaptcha.validation.RecaptchaValidator;
import com.github.mkopylec.recaptcha.validation.ValidationResult;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class DefaultRecaptchaValidator
implements RecaptchaValidator {
    private static final Logger log = LoggerFactory.getLogger(DefaultRecaptchaValidator.class);
    protected final RestTemplate restTemplate;
    protected final RecaptchaProperties.Validation validation;
    protected final IpAddressResolver ipAddressResolver;

    public DefaultRecaptchaValidator(RestTemplate restTemplate, RecaptchaProperties recaptcha, IpAddressResolver ipAddressResolver) {
        this.restTemplate = restTemplate;
        this.validation = recaptcha.getValidation();
        this.ipAddressResolver = ipAddressResolver;
    }

    @Override
    public ValidationResult validate(HttpServletRequest request) {
        return this.validate(request, this.ipAddressResolver.resolveClientIp(request));
    }

    @Override
    public ValidationResult validate(HttpServletRequest request, String ipAddress) {
        return this.validate(request.getParameter(this.validation.getResponseParameter()), ipAddress);
    }

    @Override
    public ValidationResult validate(HttpServletRequest request, String ipAddress, String secretKey) {
        return this.validate(request.getParameter(this.validation.getResponseParameter()), ipAddress, secretKey);
    }

    @Override
    public ValidationResult validate(String userResponse, HttpServletRequest request) {
        return this.validate(userResponse, this.ipAddressResolver.resolveClientIp(request));
    }

    @Override
    public ValidationResult validate(String userResponse) {
        return this.validate(userResponse, "");
    }

    @Override
    public ValidationResult validate(String userResponse, String ipAddress) {
        return this.validate(userResponse, ipAddress, this.validation.getSecretKey());
    }

    @Override
    public ValidationResult validate(String userResponse, String ipAddress, String secretKey) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"secret", (Object)secretKey);
        parameters.add((Object)"response", (Object)userResponse);
        parameters.add((Object)"remoteip", (Object)ipAddress);
        log.debug("Validating reCAPTCHA:\n    verification url: {}\n    verification parameters: {}", (Object)this.validation.getVerificationUrl(), (Object)parameters);
        try {
            ValidationResult result = (ValidationResult)this.restTemplate.postForEntity(this.validation.getVerificationUrl(), (Object)parameters, ValidationResult.class, new Object[0]).getBody();
            log.debug("reCAPTCHA validation finished: {}", (Object)result);
            return result;
        }
        catch (RestClientException ex) {
            throw new RecaptchaValidationException(userResponse, this.validation.getVerificationUrl(), ex);
        }
    }
}

