/*
 * Decompiled with CFR 0.152.
 */
package javapns.feedback;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.LinkedList;
import javapns.communication.exceptions.CommunicationException;
import javapns.communication.exceptions.KeystoreException;
import javapns.devices.Device;
import javapns.devices.DeviceFactory;
import javapns.devices.implementations.basic.BasicDevice;
import javapns.devices.implementations.basic.BasicDeviceFactory;
import javapns.feedback.AppleFeedbackServer;
import javapns.feedback.ConnectionToFeedbackServer;
import javax.net.ssl.SSLSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedbackServiceManager {
    private static final Logger logger = LoggerFactory.getLogger(FeedbackServiceManager.class);
    private static final int FEEDBACK_TUPLE_SIZE = 38;
    @Deprecated
    private DeviceFactory deviceFactory;

    @Deprecated
    private FeedbackServiceManager(DeviceFactory deviceFactory) {
        this.setDeviceFactory(deviceFactory);
    }

    public FeedbackServiceManager() {
        this.setDeviceFactory(new BasicDeviceFactory());
    }

    public LinkedList<Device> getDevices(AppleFeedbackServer server) throws KeystoreException, CommunicationException {
        ConnectionToFeedbackServer connectionHelper = new ConnectionToFeedbackServer(server);
        SSLSocket socket = connectionHelper.getSSLSocket();
        return this.getDevices(socket);
    }

    private LinkedList<Device> getDevices(SSLSocket socket) throws CommunicationException {
        LinkedList<Device> listDev = null;
        try {
            int nbBytes;
            InputStream socketStream = socket.getInputStream();
            byte[] b = new byte[1024];
            ByteArrayOutputStream message = new ByteArrayOutputStream();
            while ((nbBytes = socketStream.read(b, 0, 1024)) != -1) {
                message.write(b, 0, nbBytes);
            }
            listDev = new LinkedList<Device>();
            byte[] listOfDevices = message.toByteArray();
            int nbTuples = listOfDevices.length / 38;
            logger.debug("Found: [" + nbTuples + "]");
            for (int i = 0; i < nbTuples; ++i) {
                int offset = i * 38;
                int firstByte = 0xFF & listOfDevices[offset];
                int secondByte = 0xFF & listOfDevices[offset + 1];
                int thirdByte = 0xFF & listOfDevices[offset + 2];
                int fourthByte = 0xFF & listOfDevices[offset + 3];
                long anUnsignedInt = (long)(firstByte << 24 | secondByte << 16 | thirdByte << 8 | fourthByte) & 0xFFFFFFFFL;
                Timestamp timestamp = new Timestamp(anUnsignedInt * 1000L);
                int deviceTokenLength = listOfDevices[offset + 4] << 8 | listOfDevices[offset + 5];
                String deviceToken = "";
                for (int j = 0; j < 32; ++j) {
                    int octet = 0xFF & listOfDevices[offset + 6 + j];
                    deviceToken = deviceToken.concat(String.format("%02x", octet));
                }
                BasicDevice device = new BasicDevice();
                device.setToken(deviceToken);
                device.setLastRegister(timestamp);
                listDev.add(device);
                logger.info("FeedbackManager retrieves one device :  " + timestamp + ";" + deviceTokenLength + ";" + deviceToken + ".");
            }
        }
        catch (Exception e) {
            logger.debug("Caught exception fetching devices from Feedback Service");
            throw new CommunicationException("Problem communicating with Feedback service", e);
        }
        finally {
            try {
                socket.close();
            }
            catch (Exception exception) {}
        }
        return listDev;
    }

    @Deprecated
    public DeviceFactory getDeviceFactory() {
        return this.deviceFactory;
    }

    @Deprecated
    private void setDeviceFactory(DeviceFactory deviceFactory) {
        this.deviceFactory = deviceFactory;
    }
}

