/*
 * Decompiled with CFR 0.152.
 */
package si.mazi.rescu.serialization;

import java.io.IOException;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.ResponseReader;

public class PlainTextResponseReader
extends ResponseReader {
    private static final Logger log = LoggerFactory.getLogger(PlainTextResponseReader.class);

    public PlainTextResponseReader(boolean ignoreHttpErrorCodes) {
        super(ignoreHttpErrorCodes);
    }

    public String read(String httpBody, Type returnType) throws IOException {
        return httpBody;
    }

    @Override
    protected RuntimeException readException(String httpBody, Class<? extends RuntimeException> exceptionType) throws IOException {
        String message = this.read(httpBody, exceptionType);
        RuntimeException constructedException = null;
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            constructedException = exceptionType.getConstructor(String.class).newInstance(message);
        }
        catch (ReflectiveOperationException e) {
            reflectiveOperationException = e;
        }
        if (reflectiveOperationException != null) {
            reflectiveOperationException = null;
            try {
                constructedException = exceptionType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                log.warn("Cannot construct a {} with message parameter. Ommiting the message, which was: {}", exceptionType, (Object)message);
            }
            catch (ReflectiveOperationException e) {
                reflectiveOperationException = e;
            }
            if (reflectiveOperationException != null) {
                log.warn("Cannot construct a {}. Throwing a RuntimeException instead. Main cause: {}", exceptionType, (Object)reflectiveOperationException.toString());
                throw new RuntimeException(message);
            }
        }
        return constructedException;
    }
}

