/*
 * Decompiled with CFR 0.152.
 */
package si.mazi.rescu.clients;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.HttpMethod;
import si.mazi.rescu.clients.HttpConnection;
import si.mazi.rescu.clients.HttpConnectionType;

public class ApacheConnection
implements HttpConnection {
    private static final Logger log = LoggerFactory.getLogger(ApacheConnection.class);
    private final String url;
    private final Proxy proxy;
    private final HttpClientBuilder builder = HttpClients.custom();
    private final RequestConfig.Builder requestConfig = RequestConfig.custom();
    private boolean executed = false;
    private HttpMethod method = HttpMethod.GET;
    private ByteArrayOutputStream out;
    private final Map<String, String> headers = new HashMap<String, String>();
    private CloseableHttpClient client;
    private CloseableHttpResponse response;

    private ApacheConnection(String url, Proxy proxy) {
        this.url = url;
        this.proxy = proxy;
    }

    public static HttpConnection create(String url, Proxy proxy) throws MalformedURLException, IOException {
        return new ApacheConnection(url, proxy);
    }

    private void exec() throws ClientProtocolException, IOException {
        HttpEntityEnclosingRequestBase req;
        HttpEntity entity;
        if (this.executed) {
            return;
        }
        HttpClientBuilder clientBuilder = this.builder.setDefaultRequestConfig(this.requestConfig.build());
        if (this.proxy != null && this.proxy != Proxy.NO_PROXY) {
            InetSocketAddress address = (InetSocketAddress)this.proxy.address();
            HttpHost proxy = new HttpHost(address.getHostName(), address.getPort());
            clientBuilder.setProxy(proxy);
        }
        this.client = clientBuilder.build();
        HttpRequestBase request = ApacheConnection.createRequest(this.method, this.url);
        if (request instanceof HttpEntityEnclosingRequestBase && this.out != null && (entity = (req = (HttpEntityEnclosingRequestBase)request).getEntity()) == null) {
            entity = new ByteArrayEntity(this.out.toByteArray());
            req.setEntity(entity);
        }
        this.headers.forEach((arg_0, arg_1) -> ((HttpRequestBase)request).addHeader(arg_0, arg_1));
        this.response = this.client.execute((HttpUriRequest)request);
        this.executed = true;
    }

    private static HttpRequestBase createRequest(HttpMethod method, String url) {
        switch (method) {
            case GET: {
                return new HttpGet(url);
            }
            case POST: {
                return new HttpPost(url);
            }
            case PUT: {
                return new HttpPut(url);
            }
            case DELETE: {
                return new HttpDelete(url);
            }
            case HEAD: {
                return new HttpHead(url);
            }
            case OPTIONS: {
                return new HttpOptions(url);
            }
            case PATCH: {
                return new HttpPatch(url);
            }
        }
        throw new RuntimeException("Not supported http method: " + (Object)((Object)method));
    }

    @Override
    public String getHeaderField(String name) {
        if (!this.executed) {
            throw new RuntimeException("Request is not executed yet.");
        }
        Header firstHeader = this.response.getFirstHeader(name);
        return firstHeader == null ? null : firstHeader.getValue();
    }

    @Override
    public void setRequestMethod(HttpMethod method) throws ProtocolException {
        this.method = method;
    }

    @Override
    public String getRequestMethod() {
        return this.method.name();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new ByteArrayOutputStream();
        }
        return this.out;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.exec();
        HttpEntity entity = this.response.getEntity();
        return entity != null ? entity.getContent() : null;
    }

    @Override
    public InputStream getErrorStream() throws IOException {
        return this.getInputStream();
    }

    @Override
    public int getResponseCode() throws IOException {
        this.exec();
        return this.response.getStatusLine().getStatusCode();
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        Stream.of(this.response.getAllHeaders()).forEach(h -> {
            ArrayList<String> list = (ArrayList<String>)result.get(h.getName());
            if (list == null) {
                list = new ArrayList<String>();
                result.put(h.getName(), list);
            }
            list.add(h.getValue());
        });
        return result;
    }

    @Override
    public void setHeader(String key, String value) {
        if ("Content-Length".equals(key)) {
            log.warn("'Content-Length' header already present, ignoring the explicitly set value: '{}'.", (Object)value);
            return;
        }
        this.headers.put(key, value);
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.requestConfig.setSocketTimeout(readTimeout);
    }

    @Override
    public void setConnectTimeout(int connTimeout) {
        this.requestConfig.setConnectTimeout(connTimeout);
    }

    @Override
    public boolean isSsl() {
        return this.url.startsWith("https");
    }

    @Override
    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        if (sslSocketFactory != null) {
            throw new UnsupportedOperationException("Setting a SSLSocketFactory not supported for Apache client");
        }
    }

    @Override
    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.builder.setSSLHostnameVerifier(hostnameVerifier);
    }

    @Override
    public HttpConnectionType getHttpConnectionType() {
        return HttpConnectionType.apache;
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        if (this.response != null) {
            this.response.close();
        }
        if (this.client != null) {
            this.client.close();
        }
    }
}

