/*
 * Decompiled with CFR 0.152.
 */
package mesosphere.marathon.client;

import feign.Feign;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.Response;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.gson.GsonDecoder;
import feign.gson.GsonEncoder;
import mesosphere.marathon.client.Marathon;
import mesosphere.marathon.client.utils.MarathonException;
import mesosphere.marathon.client.utils.ModelUtils;

public class MarathonClient {
    public static Marathon getInstance(String endpoint) {
        GsonDecoder decoder = new GsonDecoder(ModelUtils.GSON);
        GsonEncoder encoder = new GsonEncoder(ModelUtils.GSON);
        return (Marathon)Feign.builder().encoder((Encoder)encoder).decoder((Decoder)decoder).errorDecoder((ErrorDecoder)new MarathonErrorDecoder()).requestInterceptor((RequestInterceptor)new MarathonHeadersInterceptor()).target(Marathon.class, endpoint);
    }

    static class MarathonErrorDecoder
    implements ErrorDecoder {
        MarathonErrorDecoder() {
        }

        public Exception decode(String methodKey, Response response) {
            return new MarathonException(response.status(), response.reason());
        }
    }

    static class MarathonHeadersInterceptor
    implements RequestInterceptor {
        MarathonHeadersInterceptor() {
        }

        public void apply(RequestTemplate template) {
            template.header("Accept", new String[]{"application/json"});
            template.header("Content-Type", new String[]{"application/json"});
        }
    }
}

