/*
 * Decompiled with CFR 0.152.
 */
package moxy;

import android.app.DialogFragment;
import android.app.Fragment;
import android.os.Build;
import android.os.Bundle;
import moxy.MvpDelegate;
import moxy.MvpDelegateHolder;

public class MvpDialogFragment
extends DialogFragment
implements MvpDelegateHolder {
    private static final int ANDROID_OS_JELLY_BEAN = 17;
    private boolean isStateSaved;
    private MvpDelegate<? extends MvpDialogFragment> mvpDelegate;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getMvpDelegate().onCreate(savedInstanceState);
    }

    public void onResume() {
        super.onResume();
        this.isStateSaved = false;
        this.getMvpDelegate().onAttach();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.isStateSaved = true;
        this.getMvpDelegate().onSaveInstanceState(outState);
        this.getMvpDelegate().onDetach();
    }

    public void onStop() {
        super.onStop();
        this.getMvpDelegate().onDetach();
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.getMvpDelegate().onDetach();
        this.getMvpDelegate().onDestroyView();
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.getActivity().isFinishing()) {
            this.getMvpDelegate().onDestroy();
            return;
        }
        if (this.isStateSaved) {
            this.isStateSaved = false;
            return;
        }
        boolean anyParentIsRemoving = false;
        if (Build.VERSION.SDK_INT >= 17) {
            for (Fragment parent = this.getParentFragment(); !anyParentIsRemoving && parent != null; parent = parent.getParentFragment()) {
                anyParentIsRemoving = parent.isRemoving();
            }
        }
        if (this.isRemoving() || anyParentIsRemoving) {
            this.getMvpDelegate().onDestroy();
        }
    }

    public MvpDelegate getMvpDelegate() {
        if (this.mvpDelegate == null) {
            this.mvpDelegate = new MvpDelegate((Object)this);
        }
        return this.mvpDelegate;
    }
}

