/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapdb;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.data.keyvalue.core.CriteriaAccessor;
import org.springframework.data.keyvalue.core.QueryEngine;
import org.springframework.data.keyvalue.core.SortAccessor;
import org.springframework.data.mapdb.MapDbKeyValueAdapter;
import org.springframework.data.mapdb.query.MapDbCriteriaAccessor;
import org.springframework.data.mapdb.query.MapDbSortAccessor;

public class MapDbQueryEngine
extends QueryEngine<MapDbKeyValueAdapter, Predicate<?>, Comparator<?>> {
    public MapDbQueryEngine() {
        super((CriteriaAccessor)new MapDbCriteriaAccessor(), (SortAccessor)new MapDbSortAccessor());
    }

    public Collection<?> execute(Predicate<?> criteria, Comparator<?> sort, int offset, int rows, Serializable keyspace) {
        Collection values = ((MapDbKeyValueAdapter)this.getAdapter()).getMap(keyspace).values();
        List result = values.parallelStream().filter(input -> criteria != null ? criteria.test(input) : true).sorted((o1, o2) -> sort != null ? sort.compare(o1, o2) : 0).collect(Collectors.toList());
        return offset != rows ? result.subList(offset, offset + rows) : result;
    }

    public long count(Predicate<?> criteria, Serializable keyspace) {
        if (criteria == null) {
            return ((MapDbKeyValueAdapter)this.getAdapter()).getMap(keyspace).getSize();
        }
        return ((MapDbKeyValueAdapter)this.getAdapter()).getMap(keyspace).values().parallelStream().filter(criteria).count();
    }
}

