/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapdb.query.predicates;

import java.lang.reflect.InvocationTargetException;
import java.util.function.Predicate;
import org.apache.commons.beanutils.PropertyUtils;

public class PropertyPredicate<V>
implements Predicate<V> {
    private final String property;
    private final Predicate<V> predicate;

    private PropertyPredicate(String property, Predicate<V> predicate) {
        this.property = property;
        this.predicate = predicate;
    }

    @Override
    public boolean test(V input) {
        try {
            return this.predicate.test(PropertyUtils.getProperty(input, (String)this.property));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }

    public static <V> Predicate<V> wrap(Predicate<V> predicate, String property) {
        return new PropertyPredicate<V>(property, predicate);
    }
}

