/*
 * Copyright 2019 Ivan Pekov
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON INFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.github.mrivanplays.bungee.vault.api;

import net.md_5.bungee.api.connection.ProxiedPlayer;

/** Represents things for the chat */
public abstract class Chat extends Permission {
  /**
   * Because BungeeCord doesn't have a service provider as well as bukkit, we should access this
   * class via a instance.
   */
  private static Chat instance;

  /**
   * Gets an instance of this class
   *
   * @return instance of this class
   */
  public static Chat getChat() {
    return instance;
  }

  /**
   * Sets an instance of this class <b>If the instance is already set, this method will throw an
   * {@link IllegalArgumentException}. If the new instance is null, the method again will throw an
   * {@link IllegalArgumentException}</b>
   *
   * @param instance new instance
   */
  public static void setInstance(Chat instance) {
    if (instance == null) {
      throw new IllegalArgumentException("New instance cannot be null");
    }
    if (Chat.instance != null) {
      throw new IllegalArgumentException("Instance already set");
    }
    Chat.instance = instance;
  }

  /**
   * Gets the player's prefix <b>Empty string if the provider is BungeeCord</b>
   *
   * @param player the player you wish to get the prefix of
   * @return player prefix
   */
  public abstract String getPlayerPrefix(ProxiedPlayer player);

  /**
   * Gets the player's suffix <b>Empty string if the provider is BungeeCord</b>
   *
   * @param player the player you wish to get the suffix of
   * @return player suffix
   */
  public abstract String getPlayerSuffix(ProxiedPlayer player);

  /**
   * Sets the player's prefix <b>Won't do anything if the provider is BungeeCord</b>
   *
   * @param player the player you wish to set the prefix of
   * @param newPrefix new prefix
   */
  public abstract void setPlayerPrefix(ProxiedPlayer player, String newPrefix);

  /**
   * Sets the player's suffix <b>Won't do anything if the provider is BungeeCord</b>
   *
   * @param player the player you with to set the suffix of
   * @param newSuffix new suffix
   */
  public abstract void setPlayerSuffix(ProxiedPlayer player, String newSuffix);
}
