/*
 * Decompiled with CFR 0.152.
 */
package com.moczul.ok2curl;

import com.moczul.ok2curl.CurlBuilder;
import com.moczul.ok2curl.Header;
import com.moczul.ok2curl.Options;
import com.moczul.ok2curl.StringUtil;
import com.moczul.ok2curl.modifier.HeaderModifier;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Request;

public class ConfigurableCurlBuilder
extends CurlBuilder {
    public static final int PART_CURL = 0;
    public static final int PART_OPTIONS = 1;
    public static final int PART_METHOD = 2;
    public static final int PART_HEADERS = 3;
    public static final int PART_CONTENT_TYPE = 4;
    public static final int PART_BODY = 5;
    public static final int PART_URL = 6;
    protected static final int[] DEFAULT_PARTS_ORDER = new int[]{0, 1, 2, 3, 4, 5, 6};
    protected final int[] partsOrder;

    public ConfigurableCurlBuilder(Request request, long limit, List<HeaderModifier> headerModifiers, Options options, String delimiter) {
        this(request, limit, headerModifiers, options, delimiter, DEFAULT_PARTS_ORDER);
    }

    public ConfigurableCurlBuilder(Request request, long limit, List<HeaderModifier> headerModifiers, Options options, String delimiter, int[] partsOrder) {
        super(request, limit, headerModifiers, options, delimiter);
        this.partsOrder = partsOrder;
    }

    @Override
    public String build() {
        ArrayList<String> parts = new ArrayList<String>();
        block9: for (int part : this.partsOrder) {
            switch (part) {
                case 0: {
                    this.addCurl(parts);
                    continue block9;
                }
                case 1: {
                    this.addOptions(parts);
                    continue block9;
                }
                case 2: {
                    this.addMethod(parts);
                    continue block9;
                }
                case 3: {
                    this.addHeaders(parts);
                    continue block9;
                }
                case 4: {
                    this.addContentType(parts);
                    continue block9;
                }
                case 5: {
                    this.addBody(parts);
                    continue block9;
                }
                case 6: {
                    this.addUrl(parts);
                }
            }
        }
        return StringUtil.join(this.delimiter, parts);
    }

    private void addCurl(List<String> parts) {
        parts.add("curl");
    }

    private void addOptions(List<String> parts) {
        parts.addAll(this.options);
    }

    private void addMethod(List<String> parts) {
        parts.add(String.format("-X %1$s", this.method.toUpperCase()));
    }

    private void addHeaders(List<String> parts) {
        for (Header header : this.headers) {
            String headerPart = String.format("-H \"%1$s:%2$s\"", header.name(), header.value());
            parts.add(headerPart);
        }
    }

    private void addContentType(List<String> parts) {
        if (this.contentType != null && !this.containsName("Content-Type", this.headers)) {
            parts.add(String.format("-H \"%1$s:%2$s\"", "Content-Type", this.contentType));
        }
    }

    private void addBody(List<String> parts) {
        if (this.body != null) {
            parts.add(String.format("-d '%1$s'", this.body));
        }
    }

    private void addUrl(List<String> parts) {
        parts.add(String.format("\"%1$s\"", this.url));
    }
}

