/*
 * Decompiled with CFR 0.152.
 */
package com.moczul.ok2curl;

import com.moczul.ok2curl.Header;
import com.moczul.ok2curl.LimitedSink;
import com.moczul.ok2curl.Options;
import com.moczul.ok2curl.StringUtil;
import com.moczul.ok2curl.modifier.HeaderModifier;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;

public class CurlBuilder {
    protected static final String FORMAT_HEADER = "-H \"%1$s:%2$s\"";
    protected static final String FORMAT_METHOD = "-X %1$s";
    protected static final String FORMAT_BODY = "-d '%1$s'";
    protected static final String FORMAT_URL = "\"%1$s\"";
    protected static final String CONTENT_TYPE = "Content-Type";
    protected final String url;
    protected final String method;
    protected final String contentType;
    protected final String body;
    protected final List<String> options;
    protected final List<Header> headers;
    protected final String delimiter;

    public CurlBuilder(Request request) {
        this(request, -1L, Collections.emptyList(), Options.EMPTY);
    }

    public CurlBuilder(Request request, long limit, List<HeaderModifier> headerModifiers, Options options) {
        this(request, limit, headerModifiers, options, " ");
    }

    public CurlBuilder(Request request, long limit, List<HeaderModifier> headerModifiers, Options options, String delimiter) {
        this.url = request.url().toString();
        this.method = request.method();
        this.options = Collections.unmodifiableList(options.list());
        this.delimiter = delimiter;
        RequestBody body = request.body();
        if (body != null) {
            this.contentType = this.getContentType(body);
            this.body = this.getBodyAsString(body, limit);
        } else {
            this.contentType = null;
            this.body = null;
        }
        Headers headers = request.headers();
        LinkedList<Header> modifiableHeaders = new LinkedList<Header>();
        for (int i = 0; i < headers.size(); ++i) {
            Header header = new Header(headers.name(i), headers.value(i));
            Header modifiedHeader = this.modifyHeader(header, headerModifiers);
            if (modifiedHeader == null) continue;
            modifiableHeaders.add(modifiedHeader);
        }
        this.headers = Collections.unmodifiableList(modifiableHeaders);
    }

    private Header modifyHeader(Header header, List<HeaderModifier> headerModifiers) {
        for (HeaderModifier modifier : headerModifiers) {
            if (!modifier.matches(header)) continue;
            return modifier.modify(header);
        }
        return header;
    }

    private String getContentType(RequestBody body) {
        MediaType mediaType = body.contentType();
        if (mediaType != null) {
            return mediaType.toString();
        }
        return null;
    }

    private String getBodyAsString(RequestBody body, long limit) {
        try {
            Buffer sink = new Buffer();
            MediaType mediaType = body.contentType();
            Charset charset = this.getCharset(mediaType);
            if (limit > 0L) {
                BufferedSink buffer = Okio.buffer((Sink)new LimitedSink(sink, limit));
                body.writeTo(buffer);
                buffer.flush();
            } else {
                body.writeTo((BufferedSink)sink);
            }
            return sink.readString(charset);
        }
        catch (IOException e) {
            return "Error while reading body: " + e.toString();
        }
    }

    private Charset getCharset(MediaType mediaType) {
        if (mediaType != null) {
            return mediaType.charset(Charset.defaultCharset());
        }
        return Charset.defaultCharset();
    }

    public String build() {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add("curl");
        parts.addAll(this.options);
        parts.add(String.format(FORMAT_METHOD, this.method.toUpperCase()));
        for (Header header : this.headers) {
            String headerPart = String.format(FORMAT_HEADER, header.name(), header.value());
            parts.add(headerPart);
        }
        if (this.contentType != null && !this.containsName(CONTENT_TYPE, this.headers)) {
            parts.add(String.format(FORMAT_HEADER, CONTENT_TYPE, this.contentType));
        }
        if (this.body != null) {
            parts.add(String.format(FORMAT_BODY, this.body));
        }
        parts.add(String.format(FORMAT_URL, this.url));
        return StringUtil.join(this.delimiter, parts);
    }

    protected boolean containsName(String name, List<Header> headers) {
        for (Header header : headers) {
            if (!header.name().equals(name)) continue;
            return true;
        }
        return false;
    }
}

