/*
 * Decompiled with CFR 0.152.
 */
package com.moczul.ok2curl;

import com.moczul.ok2curl.CurlBuilder;
import com.moczul.ok2curl.Options;
import com.moczul.ok2curl.logger.Loggable;
import com.moczul.ok2curl.modifier.HeaderModifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class CurlInterceptor
implements Interceptor {
    private static final long DEFAULT_LIMIT = 0x100000L;
    private static final String DEFAULT_DELIMITER = " ";
    protected final Loggable logger;
    protected final long limit;
    protected final List<HeaderModifier> headerModifiers = new ArrayList<HeaderModifier>();
    protected final Options options;
    protected final String delimiter;

    public CurlInterceptor(Loggable logger) {
        this(logger, 0x100000L, Collections.emptyList(), Options.EMPTY, DEFAULT_DELIMITER);
    }

    public CurlInterceptor(Loggable logger, Options options) {
        this(logger, 0x100000L, Collections.emptyList(), options, DEFAULT_DELIMITER);
    }

    public CurlInterceptor(Loggable logger, List<HeaderModifier> headerModifiers) {
        this(logger, 0x100000L, headerModifiers, Options.EMPTY, DEFAULT_DELIMITER);
    }

    public CurlInterceptor(Loggable logger, long limit) {
        this(logger, limit, Collections.emptyList(), Options.EMPTY, DEFAULT_DELIMITER);
    }

    public CurlInterceptor(Loggable logger, long limit, List<HeaderModifier> headerModifiers, Options options) {
        this(logger, limit, headerModifiers, options, DEFAULT_DELIMITER);
    }

    public CurlInterceptor(Loggable logger, long limit, List<HeaderModifier> headerModifiers, Options options, String delimiter) {
        this.logger = logger;
        this.limit = limit;
        this.headerModifiers.addAll(headerModifiers);
        this.options = options;
        this.delimiter = delimiter;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request copy = request.newBuilder().build();
        String curl = this.getCurlBuilder(copy).build();
        this.logger.log(curl);
        return chain.proceed(request);
    }

    protected CurlBuilder getCurlBuilder(Request copy) {
        return new CurlBuilder(copy, this.limit, this.headerModifiers, this.options, this.delimiter);
    }
}

