/*
 * Decompiled with CFR 0.152.
 */
package com.moczul.ok2curl;

import java.io.IOException;
import okio.Buffer;
import okio.Sink;
import okio.Timeout;

public class LimitedSink
implements Sink {
    private final Buffer limited;
    private long total;

    public LimitedSink(Buffer limited, long limit) {
        if (limited == null) {
            throw new NullPointerException("limited can not be null");
        }
        if (limit <= 0L) {
            throw new IllegalArgumentException("limit has to be grater than 0");
        }
        this.limited = limited;
        this.total = limit;
    }

    public void write(Buffer source, long byteCount) throws IOException {
        if (this.total > 0L) {
            long toWrite = Math.min(this.total, byteCount);
            this.limited.write(source, toWrite);
            this.total -= toWrite;
        }
    }

    public void flush() throws IOException {
        this.limited.flush();
    }

    public Timeout timeout() {
        return Timeout.NONE;
    }

    public void close() throws IOException {
        this.limited.close();
    }
}

