/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrpowers.spark.daria.delta;

import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class DeltaLogHelpers$ {
    public static final DeltaLogHelpers$ MODULE$;

    static {
        new DeltaLogHelpers$();
    }

    public int num1GbPartitions(Dataset<Row> deltaLogDF, int minNumPartitions) {
        long numBytes = ((Row)deltaLogDF.agg(functions$.MODULE$.sum("size"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).head()).getLong(0);
        long numGigabytes = numBytes / 0x40000000L;
        return numGigabytes < (long)minNumPartitions ? minNumPartitions : (int)numGigabytes;
    }

    public int num1GbPartitions$default$2() {
        return 1;
    }

    public Dataset<Row> withBytesToGigabytes(String bytesColName, String outputColName, Dataset<Row> df) {
        return df.withColumn(outputColName, functions$.MODULE$.col(bytesColName).$div((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)0x40000000L))));
    }

    public String withBytesToGigabytes$default$2() {
        return "gigabytes";
    }

    public Dataset<Row> partitionedLake1GbChunks(Dataset<Row> deltaLogDF, String partitionKey, int minNumPartitions) {
        String string = this.withBytesToGigabytes$default$2();
        return deltaLogDF.withColumn("partitionValue", functions$.MODULE$.col("partitionValues").apply((Object)partitionKey)).groupBy("partitionValue", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).sum((Seq)Nil$.MODULE$).transform((Function1)new Serializable(string){
            public static final long serialVersionUID = 0L;
            private final String eta$0$1$1;

            public final Dataset<Row> apply(Dataset<Row> df) {
                return DeltaLogHelpers$.MODULE$.withBytesToGigabytes("sum(size)", this.eta$0$1$1, df);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        }).withColumn("num_1GB_partitions", functions$.MODULE$.when(functions$.MODULE$.col("gigabytes").$less((Object)BoxesRunTime.boxToInteger((int)minNumPartitions)), (Object)BoxesRunTime.boxToInteger((int)minNumPartitions)).otherwise((Object)functions$.MODULE$.col("gigabytes").cast("int")));
    }

    public int partitionedLake1GbChunks$default$3() {
        return 1;
    }

    private DeltaLogHelpers$() {
        MODULE$ = this;
    }
}

