/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrpowers.spark.daria.sql;

import com.github.mrpowers.spark.daria.sql.DataFrameValidator;
import com.github.mrpowers.spark.daria.sql.DataFrameValidator$class;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxesRunTime;

public final class DataFrameHelpers$
implements DataFrameValidator {
    public static final DataFrameHelpers$ MODULE$;
    private SparkSession spark;
    private volatile boolean bitmap$0;

    static {
        new DataFrameHelpers$();
    }

    private SparkSession spark$lzycompute() {
        DataFrameHelpers$ dataFrameHelpers$ = this;
        synchronized (dataFrameHelpers$) {
            if (!this.bitmap$0) {
                this.spark = SparkSession$.MODULE$.builder().master("local").appName("spark session").getOrCreate();
                this.bitmap$0 = true;
            }
            return this.spark;
        }
    }

    @Override
    public void validatePresenceOfColumns(Dataset<Row> df, Seq<String> requiredColNames) {
        DataFrameValidator$class.validatePresenceOfColumns(this, df, requiredColNames);
    }

    @Override
    public void validateSchema(Dataset<Row> df, StructType requiredSchema) {
        DataFrameValidator$class.validateSchema(this, df, requiredSchema);
    }

    @Override
    public void validateAbsenceOfColumns(Dataset<Row> df, Seq<String> prohibitedColNames) {
        DataFrameValidator$class.validateAbsenceOfColumns(this, df, prohibitedColNames);
    }

    public <keyType, valueType> Map<keyType, valueType> twoColumnsToMap(Dataset<Row> df, String keyColName, String valueColName, TypeTags.TypeTag<keyType> evidence$1, TypeTags.TypeTag<valueType> evidence$2) {
        this.validatePresenceOfColumns(df, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{keyColName, valueColName}))));
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])df.select(keyColName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{valueColName})).collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<keyType, valueType> apply(Row r) {
                return new Tuple2(r.apply(0), r.apply(1));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
    }

    public <T> Object columnToArray(Dataset<Row> df, String colName, ClassTag<T> evidence$3) {
        return Predef$.MODULE$.refArrayOps((Object[])df.select(colName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final T apply(Row r) {
                return (T)r.apply(0);
            }
        }, Array$.MODULE$.canBuildFrom(evidence$3));
    }

    public <T> List<T> columnToList(Dataset<Row> df, String colName, ClassTag<T> evidence$4) {
        return Predef$.MODULE$.genericArrayOps(this.columnToArray(df, colName, evidence$4)).toList();
    }

    public Map<String, Object>[] toArrayOfMaps(Dataset<Row> df) {
        return (Map[])Predef$.MODULE$.refArrayOps((Object[])df.collect()).map((Function1)new Serializable(df){
            public static final long serialVersionUID = 0L;
            private final Dataset df$1;

            public final Map<String, Object> apply(Row r) {
                return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])this.df$1.columns()).zip((GenIterable)r.toSeq(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))));
            }
            {
                this.df$1 = df$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Map.class)));
    }

    public void printAthenaCreateTable(Dataset<Row> df, String athenaTableName, String s3location) {
        Seq fields = (Seq)df.schema().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField f) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.name(), DataFrameHelpers$.MODULE$.sparkTypeToAthenaType(f.dataType().toString())}));
            }
        }, Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE EXTERNAL TABLE IF NOT EXISTS ", "("})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{athenaTableName})));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"  ").append((Object)fields.mkString(",\n  ")).toString());
        Predef$.MODULE$.println((Object)")");
        Predef$.MODULE$.println((Object)"STORED AS PARQUET");
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOCATION '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s3location})));
    }

    public String sparkTypeToAthenaType(String sparkType) {
        String string = sparkType;
        String string2 = "StringType".equals(string) ? "STRING" : ("IntegerType".equals(string) ? "INT" : ("DateType".equals(string) ? "DATE" : ("DecimalType".equals(string) ? "DECIMAL" : ("FloatType".equals(string) ? "FLOAT" : ("LongType".equals(string) ? "BIGINT" : ("TimestampType".equals(string) ? "TIMESTAMP" : "STRING"))))));
        return string2;
    }

    public SparkSession spark() {
        return this.bitmap$0 ? this.spark : this.spark$lzycompute();
    }

    public void writeTimestamped(Dataset<Row> df, String outputDirname, Option<Object> numPartitions, boolean overwriteLatest) {
        String timestamp = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String outputPath = new StringBuilder().append((Object)outputDirname).append((Object)"/").append((Object)timestamp).toString();
        if (numPartitions.isEmpty()) {
            df.write().parquet(outputPath);
        } else {
            int p = BoxesRunTime.unboxToInt((Object)numPartitions.get());
            df.repartition(p).write().parquet(outputPath);
        }
        if (overwriteLatest) {
            Seq latestData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputPath}))}));
            List latestSchema = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("latest_path", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}));
            Dataset latestDF = this.spark().createDataFrame(this.spark().sparkContext().parallelize(latestData, this.spark().sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class)), StructType$.MODULE$.apply((Seq)latestSchema));
            latestDF.write().option("header", "false").option("delimiter", ",").mode(SaveMode.Overwrite).csv(new StringBuilder().append((Object)outputDirname).append((Object)"/latest").toString());
        }
    }

    public Option<Object> writeTimestamped$default$3() {
        return None$.MODULE$;
    }

    public boolean writeTimestamped$default$4() {
        return true;
    }

    public Dataset<Row> readTimestamped(String dirname) {
        Dataset latestDF = this.spark().read().option("header", "false").option("delimiter", ",").csv(new StringBuilder().append((Object)dirname).append((Object)"/latest").toString());
        String latestPath = ((Row)latestDF.head()).getString(0);
        return this.spark().read().parquet(latestPath);
    }

    private DataFrameHelpers$() {
        MODULE$ = this;
        DataFrameValidator$class.$init$(this);
    }
}

