/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrpowers.spark.fast.tests;

import com.github.mrpowers.spark.fast.tests.ArrayPrettyPrint$;
import com.github.mrpowers.spark.fast.tests.DatasetComparer;
import com.github.mrpowers.spark.fast.tests.DatasetComparerLike$;
import com.github.mrpowers.spark.fast.tests.DatasetContentMismatch;
import com.github.mrpowers.spark.fast.tests.DatasetCountMismatch;
import com.github.mrpowers.spark.fast.tests.DatasetSchemaMismatch;
import com.github.mrpowers.spark.fast.tests.RddHelpers$;
import com.github.mrpowers.spark.fast.tests.RowComparer$;
import com.github.mrpowers.spark.fast.tests.SchemaComparer$;
import com.github.mrpowers.spark.fast.tests.ufansi.Color$;
import com.github.mrpowers.spark.fast.tests.ufansi.Str;
import com.github.mrpowers.spark.fast.tests.ufansi.Str$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public abstract class DatasetComparer$class {
    private static String schemaMismatchMessage(DatasetComparer $this, Dataset actualDS, Dataset expectedDS) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\nActual Schema:\n", "\nExpected Schema:\n", "\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{actualDS.schema(), expectedDS.schema()}));
    }

    private static String betterSchemaMismatchMessage(DatasetComparer $this, Dataset actualDS, Dataset expectedDS) {
        return new StringBuilder().append((Object)"\nActual Schema Field | Expected Schema Field\n").append((Object)((TraversableOnce)((TraversableLike)actualDS.schema().zipAll((GenIterable)expectedDS.schema(), (Object)"", (Object)"", Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Str apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2;
                block6: {
                    Str str;
                    block3: {
                        block5: {
                            block4: {
                                block2: {
                                    Object sf2;
                                    Object sf1;
                                    tuple2 = x0$1;
                                    if (tuple2 == null || !BoxesRunTime.equals((Object)(sf1 = tuple2._1()), (Object)(sf2 = tuple2._2()))) break block2;
                                    str = Color$.MODULE$.Blue().apply(Str$.MODULE$.implicitApply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " | ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sf1, sf2}))));
                                    break block3;
                                }
                                if (tuple2 == null) break block4;
                                Object object = tuple2._1();
                                Object sf2 = tuple2._2();
                                if (!"".equals(object)) break block4;
                                str = Color$.MODULE$.Red().apply(Str$.MODULE$.implicitApply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MISSING | ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sf2}))));
                                break block3;
                            }
                            if (tuple2 == null) break block5;
                            Object sf1 = tuple2._1();
                            Object object = tuple2._2();
                            if (!"".equals(object)) break block5;
                            str = Color$.MODULE$.Red().apply(Str$.MODULE$.implicitApply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " | MISSING"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sf1}))));
                            break block3;
                        }
                        if (tuple2 == null) break block6;
                        Object sf1 = tuple2._1();
                        Object sf2 = tuple2._2();
                        str = Color$.MODULE$.Red().apply(Str$.MODULE$.implicitApply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " | ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sf1, sf2}))));
                    }
                    return str;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n")).toString();
    }

    private static String countMismatchMessage(DatasetComparer $this, long actualCount, long expectedCount) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\nActual DataFrame Row Count: '", "'\nExpected DataFrame Row Count: '", "'\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)actualCount), BoxesRunTime.boxToLong((long)expectedCount)}));
    }

    private static String betterContentMismatchMessage(DatasetComparer $this, Object a, Object e, int truncate) {
        Tuple2[] arr = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])new Tuple2[]{new Tuple2((Object)"Actual Content", (Object)"Expected Content")}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(a).zipAll((GenIterable)Predef$.MODULE$.genericWrapArray(e), (Object)"", (Object)"", Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        return (String)new StringOps(Predef$.MODULE$.augmentString("Diffs\n")).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString(ArrayPrettyPrint$.MODULE$.showTwoColumnString(arr, truncate))), Predef$.MODULE$.StringCanBuildFrom());
    }

    private static String unequalRDDMessage(DatasetComparer $this, RDD unequalRDD, int length) {
        return new StringBuilder().append((Object)"\nRow Index | Actual Row | Expected Row\n").append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])unequalRDD.take(length)).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Str apply(Tuple2<Object, Tuple2<Object, Object>> x0$2) {
                Tuple2<Object, Tuple2<Object, Object>> tuple2 = x0$2;
                if (tuple2 != null) {
                    long idx = tuple2._1$mcJ$sp();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        Object left = tuple22._1();
                        Object right = tuple22._2();
                        Str str = Color$.MODULE$.Red().apply(Str$.MODULE$.implicitApply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " | ", " | ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)idx), left, right}))));
                        return str;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Str.class)))).mkString("\n")).toString();
    }

    public static void assertSmallDatasetEquality(DatasetComparer $this, Dataset actualDS, Dataset expectedDS, boolean ignoreNullable, boolean ignoreColumnNames, boolean orderedComparison, int truncate) {
        block5: {
            Object e;
            Object a;
            block8: {
                block7: {
                    block6: {
                        if (!SchemaComparer$.MODULE$.equals(actualDS.schema(), expectedDS.schema(), ignoreNullable, ignoreColumnNames)) break block5;
                        if (!orderedComparison) break block6;
                        Object a2 = actualDS.collect();
                        Object e2 = expectedDS.collect();
                        if (!Predef$.MODULE$.genericArrayOps(a2).sameElements((GenIterable)Predef$.MODULE$.genericWrapArray(e2))) {
                            throw new DatasetContentMismatch(DatasetComparer$class.betterContentMismatchMessage($this, a2, e2, truncate));
                        }
                        break block7;
                    }
                    a = $this.defaultSortDataset(actualDS).collect();
                    e = $this.defaultSortDataset(expectedDS).collect();
                    if (!Predef$.MODULE$.genericArrayOps(a).sameElements((GenIterable)Predef$.MODULE$.genericWrapArray(e))) break block8;
                }
                return;
            }
            throw new DatasetContentMismatch(DatasetComparer$class.betterContentMismatchMessage($this, a, e, truncate));
        }
        throw new DatasetSchemaMismatch(DatasetComparer$class.betterSchemaMismatchMessage($this, actualDS, expectedDS));
    }

    public static boolean assertSmallDatasetEquality$default$3(DatasetComparer $this) {
        return false;
    }

    public static boolean assertSmallDatasetEquality$default$4(DatasetComparer $this) {
        return false;
    }

    public static boolean assertSmallDatasetEquality$default$5(DatasetComparer $this) {
        return true;
    }

    public static int assertSmallDatasetEquality$default$6(DatasetComparer $this) {
        return 500;
    }

    public static Dataset defaultSortDataset(DatasetComparer $this, Dataset ds) {
        String[] colNames = (String[])Predef$.MODULE$.refArrayOps((Object[])ds.columns()).sorted((Ordering)Ordering.String$.MODULE$);
        Column[] cols = (Column[])Predef$.MODULE$.refArrayOps((Object[])colNames).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Column apply(String colName) {
                return functions$.MODULE$.col(colName);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        return ds.sort((Seq)Predef$.MODULE$.wrapRefArray((Object[])cols));
    }

    public static void assertLargeDatasetEquality(DatasetComparer $this, Dataset actualDS, Dataset expectedDS, Function2 equals2, boolean ignoreNullable, boolean ignoreColumnNames, boolean orderedComparison, ClassTag evidence$1) {
        if (SchemaComparer$.MODULE$.equals(actualDS.schema(), expectedDS.schema(), ignoreNullable, ignoreColumnNames)) {
            if (orderedComparison) {
                DatasetComparer$class.throwIfDatasetsAreUnequal$1($this, actualDS, expectedDS, equals2, evidence$1);
            } else {
                DatasetComparer$class.throwIfDatasetsAreUnequal$1($this, $this.defaultSortDataset(actualDS), $this.defaultSortDataset(expectedDS), equals2, evidence$1);
            }
            return;
        }
        throw new DatasetSchemaMismatch(DatasetComparer$class.betterSchemaMismatchMessage($this, actualDS, expectedDS));
    }

    public static Function2 assertLargeDatasetEquality$default$3(DatasetComparer $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Object o1, Object o2) {
                return DatasetComparerLike$.MODULE$.naiveEquality(o1, o2);
            }
        };
    }

    public static boolean assertLargeDatasetEquality$default$4(DatasetComparer $this) {
        return false;
    }

    public static boolean assertLargeDatasetEquality$default$5(DatasetComparer $this) {
        return false;
    }

    public static boolean assertLargeDatasetEquality$default$6(DatasetComparer $this) {
        return true;
    }

    public static void assertApproximateDataFrameEquality(DatasetComparer $this, Dataset actualDF, Dataset expectedDF, double precision, boolean ignoreNullable, boolean ignoreColumnNames, boolean orderedComparison) {
        Serializable e = new Serializable($this, precision){
            public static final long serialVersionUID = 0L;
            private final double precision$1;

            public final boolean apply(Row r1, Row r2) {
                return r1.equals((Object)r2) || RowComparer$.MODULE$.areRowsEqual(r1, r2, this.precision$1);
            }
            {
                this.precision$1 = precision$1;
            }
        };
        $this.assertLargeDatasetEquality(actualDF, expectedDF, e, ignoreNullable, ignoreColumnNames, orderedComparison, ClassTag$.MODULE$.apply(Row.class));
    }

    public static boolean assertApproximateDataFrameEquality$default$4(DatasetComparer $this) {
        return false;
    }

    public static boolean assertApproximateDataFrameEquality$default$5(DatasetComparer $this) {
        return false;
    }

    public static boolean assertApproximateDataFrameEquality$default$6(DatasetComparer $this) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final Tuple2[] throwIfDatasetsAreUnequal$1(DatasetComparer $this, Dataset ds1, Dataset ds2, Function2 equals$1, ClassTag evidence$1$1) {
        try {
            void var13_10;
            void var12_9;
            ds1.rdd().cache();
            ds2.rdd().cache();
            long actualCount = ds1.rdd().count();
            long expectedCount = ds2.rdd().count();
            if (actualCount != expectedCount) {
                throw new DatasetCountMismatch(DatasetComparer$class.countMismatchMessage($this, actualCount, expectedCount));
            }
            RDD expectedIndexValue = RddHelpers$.MODULE$.zipWithIndex(ds1.rdd());
            RDD resultIndexValue = RddHelpers$.MODULE$.zipWithIndex(ds2.rdd());
            RDD unequalRDD = RDD$.MODULE$.rddToPairRDDFunctions(expectedIndexValue, ClassTag$.MODULE$.Long(), evidence$1$1, (Ordering)Ordering.Long$.MODULE$).join(resultIndexValue).filter((Function1)new Serializable($this, equals$1){
                public static final long serialVersionUID = 0L;
                private final Function2 equals$1;

                public final boolean apply(Tuple2<Object, Tuple2<T, T>> x0$3) {
                    Tuple2 tuple2;
                    Tuple2<Object, Tuple2<T, T>> tuple22 = x0$3;
                    if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                        Object o2;
                        Object o1 = tuple2._1();
                        boolean bl = !BoxesRunTime.unboxToBoolean((Object)this.equals$1.apply(o1, o2 = tuple2._2()));
                        return bl;
                    }
                    throw new MatchError(tuple22);
                }
                {
                    this.equals$1 = equals$1;
                }
            });
            int maxUnequalRowsToShow = 10;
            if (unequalRDD.isEmpty()) {
                return (Tuple2[])unequalRDD.take(maxUnequalRowsToShow);
            }
            throw new DatasetContentMismatch(DatasetComparer$class.unequalRDDMessage($this, (RDD)var12_9, (int)var13_10));
        }
        finally {
            ds1.rdd().unpersist(ds1.rdd().unpersist$default$1());
            ds2.rdd().unpersist(ds2.rdd().unpersist$default$1());
        }
    }

    public static void $init$(DatasetComparer $this) {
    }
}

