/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrpowers.spark.fast.tests;

import java.io.Serializable;
import java.sql.Date;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class DataFramePrettyPrint$ {
    public static final DataFramePrettyPrint$ MODULE$ = new DataFramePrettyPrint$();

    public String showString(Dataset<Row> df, int _numRows, int truncate) {
        BoxedUnit boxedUnit;
        int numRows = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(_numRows), 0);
        Row[] takeResult = (Row[])df.take(numRows + 1);
        boolean hasMoreData = takeResult.length > numRows;
        Row[] data = (Row[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])takeResult), numRows);
        Seq seq = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])df.schema().fieldNames()));
        IndexedSeq rows = Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])data), (Function1 & Serializable)row -> (Seq)row.toSeq().map((Function1 & Serializable)cell -> {
            void var3_8;
            String string;
            Object object = cell;
            if (object == null) {
                string = "null";
            } else if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                string = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(byArray), (Function1 & Serializable)x$1 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)x$1))})), ClassTag$.MODULE$.apply(String.class))).mkString("[", " ", "]");
            } else if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
                Object object2 = object;
                string = Predef$.MODULE$.genericWrapArray(object2).mkString("[", ", ", "]");
            } else if (object instanceof Seq) {
                Seq seq = (Seq)object;
                string = seq.mkString("[", ", ", "]");
            } else if (object instanceof Date) {
                Date date = (Date)object;
                string = date.toLocalDate().format(DateTimeFormatter.ISO_DATE);
            } else {
                string = cell.toString();
            }
            String str = string;
            return truncate > 0 && str.length() > truncate ? (truncate < 4 ? str.substring(0, truncate) : new StringBuilder(3).append(str.substring(0, truncate - 3)).append("...").toString()) : var3_8;
        }), ClassTag$.MODULE$.apply(Seq.class))), (Object)seq, ClassTag$.MODULE$.apply(Seq.class)));
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        int numCols = df.schema().fieldNames().length;
        int[] colWidths = (int[])Array$.MODULE$.fill(numCols, (Function0)(JFunction0.mcI.sp & Serializable)() -> 3, (ClassTag)ClassTag$.MODULE$.Int());
        rows.foreach((Function1 & Serializable)row -> {
            DataFramePrettyPrint$.$anonfun$showString$5(colWidths, row);
            return BoxedUnit.UNIT;
        });
        String sep = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(colWidths), (Function1 & Serializable)x$3 -> StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("-"), BoxesRunTime.unboxToInt((Object)x$3)), ClassTag$.MODULE$.apply(String.class))).addString(sb, "+", "+", "+\n").toString();
        Seq h = (Seq)((IterableOps)rows.head()).zipWithIndex();
        ((IterableOnceOps)h.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String cell = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            String string = truncate > 0 ? StringUtils.leftPad((String)cell, (int)colWidths[i]) : StringUtils.rightPad((String)cell, (int)colWidths[i]);
            return string;
        })).addString(sb, "|", "|", "|\n");
        sb.append(sep);
        ((IterableOps)rows.tail()).map((Function1 & Serializable)x$4 -> ((IterableOnceOps)((IterableOps)x$4.zipWithIndex()).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String cell = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            String string = truncate > 0 ? StringUtils.leftPad((String)cell.toString(), (int)colWidths[i]) : StringUtils.rightPad((String)cell.toString(), (int)colWidths[i]);
            return string;
        })).addString(sb, "|", "|", "|\n"));
        sb.append(sep);
        if (hasMoreData) {
            String rowsString = numRows == 1 ? "row" : "rows";
            boxedUnit = sb.append(new StringBuilder(19).append("only showing top ").append(numRows).append(" ").append(rowsString).append("\n").toString());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return sb.toString();
    }

    public int showString$default$3() {
        return 20;
    }

    public static final /* synthetic */ boolean $anonfun$showString$6(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$showString$7(int[] colWidths$1, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String cell = (String)tuple2._1();
        int i = tuple2._2$mcI$sp();
        colWidths$1[i] = package$.MODULE$.max(colWidths$1[i], cell.length());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$showString$5(int[] colWidths$1, Seq row) {
        ((IterableOps)row.zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)DataFramePrettyPrint$.$anonfun$showString$6(check$ifrefutable$1))).foreach((Function1 & Serializable)x$2 -> {
            DataFramePrettyPrint$.$anonfun$showString$7(colWidths$1, x$2);
            return BoxedUnit.UNIT;
        });
    }

    private DataFramePrettyPrint$() {
    }
}

