/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrstampy.esp.openbci;

import com.github.mrstampy.esp.multiconnectionsocket.AbstractMultiConnectionSocket;
import com.github.mrstampy.esp.multiconnectionsocket.EspChannel;
import com.github.mrstampy.esp.multiconnectionsocket.MultiConnectionSocketException;
import com.github.mrstampy.esp.openbci.OpenBCIChannelCommand;
import com.github.mrstampy.esp.openbci.OpenBCICommand;
import com.github.mrstampy.esp.openbci.OpenBCIConstants;
import com.github.mrstampy.esp.openbci.OpenBCIDSPValues;
import com.github.mrstampy.esp.openbci.OpenBCIProperties;
import com.github.mrstampy.esp.openbci.OpenBCISubscriptionHandlerAdapter;
import com.github.mrstampy.esp.openbci.SampleBuffer;
import com.github.mrstampy.esp.openbci.rxtx.RxtxDataBuffer;
import com.github.mrstampy.esp.openbci.rxtx.RxtxNativeLibLoader;
import com.github.mrstampy.esp.openbci.subscription.OpenBCIEvent;
import com.github.mrstampy.esp.openbci.subscription.OpenBCIEventListener;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javolution.util.FastList;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.transport.serial.SerialAddress;
import org.apache.mina.transport.serial.SerialConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action1;
import rx.schedulers.Schedulers;

public class MultiConnectOpenBCISocket
extends AbstractMultiConnectionSocket<byte[]>
implements OpenBCIConstants {
    private static final Logger log = LoggerFactory.getLogger(MultiConnectOpenBCISocket.class);
    private SerialConnector connector;
    private List<OpenBCIEventListener> listeners = new FastList();
    private OpenBCISubscriptionHandlerAdapter subscriptionHandlerAdapter;
    private Map<Integer, SampleBuffer> samples = new ConcurrentHashMap<Integer, SampleBuffer>();
    private Scheduler scheduler = Schedulers.executor((ScheduledExecutorService)Executors.newScheduledThreadPool(5));
    private Subscription subscription;
    private OpenBCICommand startCommand = OpenBCICommand.START_BINARY;

    static {
        try {
            MultiConnectOpenBCISocket.initRxtx();
        }
        catch (Exception e) {
            log.error("Unexpected exception loading RXTX native library", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static void initRxtx() throws IOException {
        if (OpenBCIProperties.getBooleanProperty("rxtx.lib.installed")) {
            return;
        }
        String osName = OpenBCIProperties.getProperty("os.override.name");
        String osArch = OpenBCIProperties.getProperty("os.override.arch");
        if (MultiConnectOpenBCISocket.isEmpty(osArch) && MultiConnectOpenBCISocket.isEmpty(osName)) {
            RxtxNativeLibLoader.loadRxtxSerialNativeLib();
        } else {
            RxtxNativeLibLoader.loadRxtxSerialNativeLib(osName, osArch);
        }
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public MultiConnectOpenBCISocket() throws IOException {
        this(false);
    }

    public MultiConnectOpenBCISocket(boolean broadcasting) throws IOException {
        super(broadcasting);
        this.setNumChannels(OpenBCIProperties.getIntegerProperty("esp.openbci.num.channels"));
        this.initConnector();
        this.initSampleBuffers();
    }

    public void sendCommand(OpenBCICommand command) {
        if (command == null || !this.isConnected()) {
            log.warn("Cannot send command {}", (Object)command);
            return;
        }
        this.connector.broadcast((Object)command.getCommand());
    }

    public void activateChannel(int channelNumber) {
        if (!this.isConnected()) {
            log.warn("Cannot send activate for {}", (Object)channelNumber);
            return;
        }
        this.connector.broadcast((Object)OpenBCIChannelCommand.getFromChannelNumber(channelNumber).getActivate());
    }

    public void deactivateChannel(int channelNumber) {
        if (!this.isConnected()) {
            log.warn("Cannot send deactivate for {}", (Object)channelNumber);
            return;
        }
        this.connector.broadcast((Object)OpenBCIChannelCommand.getFromChannelNumber(channelNumber).getDeactivate());
    }

    public void activateLeadoffN(int channelNumber) {
        if (!this.isConnected()) {
            log.warn("Cannot send activateLeadoffN for {}", (Object)channelNumber);
            return;
        }
        this.connector.broadcast((Object)OpenBCIChannelCommand.getFromChannelNumber(channelNumber).getActivateLeadoffN());
    }

    public void activateLeadoffP(int channelNumber) {
        if (!this.isConnected()) {
            log.warn("Cannot send activateLeadoffP for {}", (Object)channelNumber);
            return;
        }
        this.connector.broadcast((Object)OpenBCIChannelCommand.getFromChannelNumber(channelNumber).getActivateLeadoffP());
    }

    public void deactivateLeadoffN(int channelNumber) {
        if (!this.isConnected()) {
            log.warn("Cannot send deactivateLeadoffN for {}", (Object)channelNumber);
            return;
        }
        this.connector.broadcast((Object)OpenBCIChannelCommand.getFromChannelNumber(channelNumber).getDeactivateLeadoffN());
    }

    public void deactivateLeadoffP(int channelNumber) {
        if (!this.isConnected()) {
            log.warn("Cannot send deactivateLeadoffP for {}", (Object)channelNumber);
            return;
        }
        this.connector.broadcast((Object)OpenBCIChannelCommand.getFromChannelNumber(channelNumber).getDeactivateLeadoffP());
    }

    public void addListener(OpenBCIEventListener l) {
        if (l != null && !this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeListener(OpenBCIEventListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    public void tune() {
        if (!this.isConnected()) {
            log.warn("Must be connected to the OpenBCI hardware to tune");
            return;
        }
        log.info("Tuning sample buffer");
        for (SampleBuffer sampleBuffer : this.samples.values()) {
            sampleBuffer.tune();
        }
        this.scheduler.schedule((Action1)new Action1<Scheduler.Inner>(){

            public void call(Scheduler.Inner t1) {
                for (SampleBuffer sampleBuffer : MultiConnectOpenBCISocket.this.samples.values()) {
                    sampleBuffer.stopTuning();
                }
            }
        }, 10L, TimeUnit.SECONDS);
    }

    public boolean isConnected() {
        return this.connector.isActive();
    }

    protected void startImpl() throws MultiConnectionSocketException {
        String error = "Could not connect to OpenBCI hardware";
        try {
            ConnectFuture cf = this.connector.connect((SocketAddress)this.getSerialAddress());
            cf.await(5000L);
            if (!cf.isConnected()) {
                throw new MultiConnectionSocketException(error);
            }
            this.sendCommand(this.getStartCommand());
        }
        catch (InterruptedException e) {
            log.error(error, (Throwable)e);
            throw new MultiConnectionSocketException(error, (Throwable)e);
        }
        this.scheduleSampling();
    }

    private void initSampleBuffers() {
        if (this.getNumChannels() <= 0) {
            throw new IllegalArgumentException("esp.openbci.num.channels property must be > 0");
        }
        int i = 1;
        while (i <= this.getNumChannels()) {
            this.samples.put(i, new SampleBuffer(i));
            ++i;
        }
    }

    private void scheduleSampling() {
        OpenBCIDSPValues values = OpenBCIDSPValues.getInstance();
        long pause = 500L;
        long snooze = values.getSampleRateSleepTime();
        TimeUnit tu = values.getSampleRateUnits();
        this.subscription = this.scheduler.schedulePeriodically((Action1)new Action1<Scheduler.Inner>(){

            public void call(Scheduler.Inner t1) {
                for (Map.Entry entry : MultiConnectOpenBCISocket.this.samples.entrySet()) {
                    MultiConnectOpenBCISocket.this.processSnapshot(((SampleBuffer)((Object)entry.getValue())).getSnapshot(), (Integer)entry.getKey());
                }
            }
        }, pause, snooze, tu);
    }

    private void processSnapshot(double[] snapshot, int channelNumber) {
        final int cn = channelNumber;
        Observable.just((Object)snapshot).subscribe((Action1)new Action1<double[]>(){

            public void call(double[] snap) {
                MultiConnectOpenBCISocket.this.notifyListeners(snap, cn);
                if (MultiConnectOpenBCISocket.this.canBroadcast()) {
                    MultiConnectOpenBCISocket.this.subscriptionHandlerAdapter.sendMultiConnectionEvent(new OpenBCIEvent(snap, cn));
                }
            }
        });
    }

    private void notifyListeners(double[] snapshot, int channelNumber) {
        if (this.listeners.isEmpty()) {
            return;
        }
        OpenBCIEvent event = new OpenBCIEvent(snapshot, channelNumber);
        for (OpenBCIEventListener l : this.listeners) {
            l.dataEventPerformed(event);
        }
    }

    protected void stopImpl() {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.sendCommand(OpenBCICommand.STOP);
            this.connector.dispose();
        }
        finally {
            if (this.subscription != null) {
                this.subscription.unsubscribe();
            }
            this.initConnector();
        }
    }

    protected IoHandler getHandlerAdapter() {
        this.subscriptionHandlerAdapter = new OpenBCISubscriptionHandlerAdapter(this);
        return this.subscriptionHandlerAdapter;
    }

    protected void parseMessage(byte[] message) {
        Observable.just((Object)message).subscribe((Action1)new Action1<byte[]>(){

            public void call(byte[] t1) {
                int numChannels = this.getNumChannels(t1);
                if (!this.isValidMessage(t1, numChannels)) {
                    log.error("Invalid message received, expected {} channels (length {}) but message length was {}", new Object[]{numChannels, this.getExpectedLength(numChannels), t1.length});
                    return;
                }
                int idx = 2;
                int channelNumber = 1;
                while (channelNumber <= numChannels) {
                    ((SampleBuffer)((Object)MultiConnectOpenBCISocket.this.samples.get(channelNumber))).addSample(this.getSample(t1, idx));
                    idx += 4;
                    ++channelNumber;
                }
            }

            private byte[] getSample(byte[] t1, int idx) {
                byte[] sample = new byte[4];
                System.arraycopy(t1, idx, sample, 0, 4);
                return sample;
            }

            private int getExpectedLength(int numChannels) {
                return 3 + 4 * numChannels;
            }

            private boolean isValidMessage(byte[] t1, int numChannels) {
                return this.getExpectedLength(numChannels) == t1.length;
            }

            private int getNumChannels(byte[] t1) {
                return t1[1] / 4 - 1;
            }
        });
    }

    private void initConnector() {
        this.connector = new SerialConnector();
        this.connector.setHandler((IoHandler)new IoHandlerAdapter(){
            private RxtxDataBuffer buffer = new RxtxDataBuffer();

            public void messageReceived(IoSession session, Object message) throws Exception {
                byte[] msg = (byte[])message;
                boolean complete = this.isCompleteMessage(msg);
                if (!complete) {
                    this.buffer.add(msg);
                }
                this.publishBufferedMessages();
                if (complete) {
                    MultiConnectOpenBCISocket.this.publishMessage(msg);
                }
            }

            private void publishBufferedMessages() {
                byte[] m = this.buffer.get();
                while (m != null) {
                    MultiConnectOpenBCISocket.this.publishMessage(m);
                    m = this.buffer.get();
                }
            }

            private boolean isCompleteMessage(byte[] message) {
                if (message[0] != -96) {
                    return false;
                }
                int i = 1;
                while (i < message.length) {
                    if (message[i] == -64) {
                        return i == message.length - 1;
                    }
                    ++i;
                }
                return false;
            }

            public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
                log.error("Unexpected RXTX exception", cause);
            }
        });
    }

    private SerialAddress getSerialAddress() {
        String portIdentifier = OpenBCIProperties.getProperty("port.identifier");
        int baudRate = OpenBCIProperties.getIntegerProperty("baud.rate");
        SerialAddress.DataBits dataBits = this.getDataBits();
        SerialAddress.StopBits stopBits = this.getStopBits();
        SerialAddress.Parity parity = this.getParity();
        SerialAddress.FlowControl flowControl = this.getFlowControl();
        return new SerialAddress(portIdentifier, baudRate, dataBits, stopBits, parity, flowControl);
    }

    private SerialAddress.FlowControl getFlowControl() {
        String fc = OpenBCIProperties.getProperty("flow.control");
        return SerialAddress.FlowControl.valueOf((String)fc);
    }

    private SerialAddress.Parity getParity() {
        String p = OpenBCIProperties.getProperty("parity");
        return SerialAddress.Parity.valueOf((String)p);
    }

    private SerialAddress.StopBits getStopBits() {
        String sbs = OpenBCIProperties.getProperty("stop.bits");
        return SerialAddress.StopBits.valueOf((String)sbs);
    }

    private SerialAddress.DataBits getDataBits() {
        String dbs = OpenBCIProperties.getProperty("data.bits");
        return SerialAddress.DataBits.valueOf((String)dbs);
    }

    public OpenBCICommand getStartCommand() {
        return this.startCommand;
    }

    public void setStartCommand(OpenBCICommand startCommand) {
        switch (startCommand) {
            case START_BINARY: 
            case START_BINARY_WAUX: 
            case START_BINARY_4CHAN: {
                break;
            }
            default: {
                log.error("startCommand must be one of the 'START_BINARY' commands");
                return;
            }
        }
        this.startCommand = startCommand;
    }

    public List<EspChannel> getChannels() {
        ArrayList<EspChannel> channels = new ArrayList<EspChannel>();
        int i = 1;
        while (i <= this.getNumChannels()) {
            channels.add(this.getChannel(i));
            ++i;
        }
        return channels;
    }

    public EspChannel getChannel(int channelNumber) {
        if (channelNumber < 1 || channelNumber > this.getNumChannels()) {
            log.warn("Invalid channel number {}. Values must be between 1 and {} inclusive", (Object)channelNumber, (Object)this.getNumChannels());
            return null;
        }
        String desc = OpenBCIProperties.getProperty("esp.openbci.channel" + channelNumber + ".desc");
        return new EspChannel(channelNumber, MultiConnectOpenBCISocket.isEmpty(desc) ? "OpenBCI Channel " + channelNumber : desc);
    }
}

