/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrstampy.esp.openbci;

public enum OpenBCIChannelCommand {
    CHANNEL_ONE(1, "q", "1", "!", "Q", "A", "Z"),
    CHANNEL_TWO(2, "w", "2", "@", "W", "S", "X"),
    CHANNEL_THREE(3, "e", "3", "#", "E", "D", "C"),
    CHANNEL_FOUR(4, "r", "4", "$", "R", "F", "V"),
    CHANNEL_FIVE(5, "t", "5", "%", "T", "G", "B"),
    CHANNEL_SIX(6, "y", "6", "^", "Y", "H", "N"),
    CHANNEL_SEVEN(7, "u", "7", "&", "U", "J", "M"),
    CHANNEL_EIGHT(8, "i", "8", "*", "I", "K", "<");

    int channelNumber;
    String activate;
    String deactivate;
    String activateLeadoffP;
    String deactivateLeadoffP;
    String activateLeadoffN;
    String deactivateLeadoffN;

    private OpenBCIChannelCommand(int channelNumber, String activate, String deactivate, String activateLeadoffP, String deactivateLeadoffP, String activateLeadoffN, String deactivateLeadoffN) {
        this.channelNumber = channelNumber;
        this.activate = activate;
        this.deactivate = deactivate;
        this.activateLeadoffP = activateLeadoffP;
        this.deactivateLeadoffP = deactivateLeadoffP;
        this.activateLeadoffN = activateLeadoffN;
        this.deactivateLeadoffN = deactivateLeadoffN;
    }

    public int getChannelNumber() {
        return this.channelNumber;
    }

    public String getActivate() {
        return this.activate;
    }

    public String getDeactivate() {
        return this.deactivate;
    }

    public String getActivateLeadoffP() {
        return this.activateLeadoffP;
    }

    public String getDeactivateLeadoffP() {
        return this.deactivateLeadoffP;
    }

    public String getActivateLeadoffN() {
        return this.activateLeadoffN;
    }

    public String getDeactivateLeadoffN() {
        return this.deactivateLeadoffN;
    }

    public static OpenBCIChannelCommand getFromChannelNumber(int channelNumber) {
        switch (channelNumber) {
            case 1: {
                return CHANNEL_ONE;
            }
            case 2: {
                return CHANNEL_TWO;
            }
            case 3: {
                return CHANNEL_THREE;
            }
            case 4: {
                return CHANNEL_FOUR;
            }
            case 5: {
                return CHANNEL_FIVE;
            }
            case 6: {
                return CHANNEL_SIX;
            }
            case 7: {
                return CHANNEL_SEVEN;
            }
            case 8: {
                return CHANNEL_EIGHT;
            }
        }
        throw new IllegalArgumentException("Channel numbers must be between 1 and 8 inclusive");
    }
}

