/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrstampy.esp.openbci;

import com.github.mrstampy.esp.dsp.AbstractDSPValues;
import com.github.mrstampy.esp.dsp.EspSignalUtilities;
import com.github.mrstampy.esp.dsp.lab.AbstractRawEspConnection;
import com.github.mrstampy.esp.multiconnectionsocket.MultiConnectionSocketException;
import com.github.mrstampy.esp.openbci.MultiConnectOpenBCISocket;
import com.github.mrstampy.esp.openbci.OpenBCIDSPValues;
import com.github.mrstampy.esp.openbci.dsp.OpenBCISignalAggregator;
import com.github.mrstampy.esp.openbci.dsp.OpenBCISignalUtilities;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OpenBCIConnection
extends AbstractRawEspConnection<MultiConnectOpenBCISocket> {
    private MultiConnectOpenBCISocket socket;
    private OpenBCISignalUtilities utilities = new OpenBCISignalUtilities();
    private Map<Integer, OpenBCISignalAggregator> aggregators = new ConcurrentHashMap<Integer, OpenBCISignalAggregator>();

    public OpenBCIConnection() throws IOException {
        this(false);
    }

    public OpenBCIConnection(boolean broadcast) throws IOException {
        this.socket = new MultiConnectOpenBCISocket(broadcast);
        this.initAggregators();
    }

    public void start() throws MultiConnectionSocketException {
        for (OpenBCISignalAggregator aggregator : this.aggregators.values()) {
            this.getSocket().addListener(aggregator);
        }
        super.start();
    }

    /*
     * Unable to fully structure code
     */
    public void stop() {
        try {
            super.stop();
        }
        finally {
            ** for (aggregator : this.aggregators.values())
        }
lbl-1000:
        // 1 sources

        {
            this.getSocket().removeListener(aggregator);
            continue;
        }
lbl8:
        // 1 sources

    }

    public EspSignalUtilities getUtilities() {
        return this.utilities;
    }

    public AbstractDSPValues getDSPValues() {
        return OpenBCIDSPValues.getInstance();
    }

    public double[][] getCurrent() {
        return this.getCurrentFor(1);
    }

    public double[][] getCurrent(int numSamples) {
        return this.getCurrentFor(numSamples, 1);
    }

    public double[][] getCurrentFor(int channelNumber) {
        return this.aggregators.get(channelNumber).getCurrentSecondOfSampledData();
    }

    public double[][] getCurrentFor(int numSamples, int channelNumber) {
        return this.aggregators.get(channelNumber).getCurrentSecondOfSampledData(numSamples);
    }

    public String getName() {
        return "ESP OpenBCI";
    }

    public MultiConnectOpenBCISocket getSocket() {
        return this.socket;
    }

    private void initAggregators() {
        int numChannels = this.getNumChannels();
        int i = 1;
        while (i <= numChannels) {
            OpenBCISignalAggregator aggregator = new OpenBCISignalAggregator(i);
            this.aggregators.put(i, aggregator);
            ++i;
        }
    }
}

