/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrstampy.esp.openbci;

import com.github.mrstampy.esp.openbci.MultiConnectOpenBCISocket;
import com.github.mrstampy.esp.openbci.dsp.OpenBCISignalAggregator;
import com.github.mrstampy.esp.openbci.subscription.OpenBCISocketConnector;

public class OpenBCITester {
    protected static void testLocalAggregation() throws Exception {
        System.out.println("Local Aggregation");
        MultiConnectOpenBCISocket socket = new MultiConnectOpenBCISocket();
        OpenBCISignalAggregator aggregator = new OpenBCISignalAggregator(1);
        socket.addListener(aggregator);
        socket.start();
        OpenBCITester.printSampleLengths(aggregator, socket);
    }

    protected static void testRemoteAggregation() throws Exception {
        System.out.println("Remote Aggregation");
        MultiConnectOpenBCISocket socket = new MultiConnectOpenBCISocket(true);
        OpenBCISocketConnector connector = new OpenBCISocketConnector("localhost");
        OpenBCISignalAggregator aggregator = new OpenBCISignalAggregator(1);
        connector.addListener(aggregator);
        connector.connect();
        connector.subscribe();
        socket.start();
        OpenBCITester.printSampleLengths(aggregator, socket);
    }

    private static void printSampleLengths(OpenBCISignalAggregator aggregator, MultiConnectOpenBCISocket socket) throws InterruptedException {
        boolean tuning = false;
        int cntr = 0;
        while (true) {
            double[][] sampled;
            int length;
            Thread.sleep(1000L);
            if (!tuning && ++cntr > 4) {
                tuning = true;
                socket.tune();
            }
            if ((length = (sampled = aggregator.getCurrentSecondOfSampledData()).length) <= 0) continue;
            System.out.println(length);
            System.out.println(sampled[0].length);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            OpenBCITester.testLocalAggregation();
        } else {
            OpenBCITester.testRemoteAggregation();
        }
    }
}

