/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrstampy.esp.openbci;

import com.github.mrstampy.esp.multiconnectionsocket.RawDataSampleBuffer;
import com.github.mrstampy.esp.openbci.OpenBCIDSPValues;
import com.github.mrstampy.esp.openbci.OpenBCIProperties;

public class SampleBuffer
extends RawDataSampleBuffer<byte[]> {
    private final int channelNumber;

    public SampleBuffer(int channelNumber) {
        super(OpenBCIProperties.getIntegerProperty("buffer.size.one.second"), OpenBCIDSPValues.getInstance().getSampleSize());
        this.channelNumber = channelNumber;
    }

    public int getChannelNumber() {
        return this.channelNumber;
    }

    public void addSample(byte[] buffer) {
        this.addSampleImpl(new double[]{this.interpretAsDouble(buffer)});
    }

    private double interpretAsDouble(byte[] byteArray) {
        return (0xFF & byteArray[3]) << 24 | (0xFF & byteArray[2]) << 16 | (0xFF & byteArray[1]) << 8 | 0xFF & byteArray[0];
    }
}

