/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrstampy.esp.openbci.dsp;

import com.github.mrstampy.esp.dsp.AbstractDSPValues;
import com.github.mrstampy.esp.dsp.EspSignalUtilities;
import com.github.mrstampy.esp.openbci.OpenBCIDSPValues;
import com.github.mrstampy.esp.openbci.OpenBCIProperties;
import ddf.minim.analysis.HammingWindow;
import ddf.minim.analysis.WindowFunction;
import java.math.BigDecimal;

public class OpenBCISignalUtilities
extends EspSignalUtilities {
    private static final BigDecimal SIGNAL_BREADTH;

    static {
        double lowVal = OpenBCIProperties.getDoubleProperty("lowest.signal.val");
        double highVal = OpenBCIProperties.getDoubleProperty("highest.signal.val");
        SIGNAL_BREADTH = new BigDecimal(highVal - lowVal);
    }

    public OpenBCISignalUtilities() {
        super((WindowFunction)new HammingWindow());
    }

    protected int getFFTSize() {
        return OpenBCIDSPValues.getInstance().getSampleSize();
    }

    protected double getSampleRate() {
        return OpenBCIDSPValues.getInstance().getSampleRate();
    }

    protected BigDecimal getRawSignalBreadth() {
        return SIGNAL_BREADTH;
    }

    public AbstractDSPValues getDSPValues() {
        return OpenBCIDSPValues.getInstance();
    }
}

