/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrstampy.esp.openbci.rxtx;

import com.github.mrstampy.esp.openbci.OpenBCIConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RxtxDataBuffer
implements OpenBCIConstants {
    private static final Logger log = LoggerFactory.getLogger(RxtxDataBuffer.class);
    private byte[] buffer = new byte[0];

    public void add(byte ... message) {
        byte[] b = new byte[this.buffer.length + message.length];
        System.arraycopy(this.buffer, 0, b, 0, this.buffer.length);
        System.arraycopy(message, 0, b, this.buffer.length, message.length);
        this.buffer = b;
    }

    public byte[] get() {
        if (this.buffer.length == 0) {
            return null;
        }
        int startIdx = -1;
        int endIdx = -1;
        int i = 0;
        while (i < this.buffer.length) {
            if (this.buffer[i] == -96) {
                startIdx = i;
            }
            if (this.buffer[i] == -64 && startIdx > -1) {
                endIdx = i;
            }
            if (startIdx >= 0 && endIdx > 0) break;
            ++i;
        }
        if (startIdx == -1 || endIdx == -1) {
            return null;
        }
        byte[] message = new byte[endIdx - startIdx + 1];
        System.arraycopy(this.buffer, startIdx, message, 0, message.length);
        if (message.length == this.buffer.length) {
            this.clear();
        } else {
            this.resizeBuffer(startIdx, endIdx);
        }
        return message.length == 0 ? null : message;
    }

    public byte[] getBufferCopy() {
        byte[] b = new byte[this.buffer.length];
        System.arraycopy(this.buffer, 0, b, 0, b.length);
        return b;
    }

    public void clear() {
        this.buffer = new byte[0];
    }

    private void resizeBuffer(int startIdx, int endIdx) {
        if (startIdx != 0) {
            log.warn("Dropping message part prior to index {}", (Object)startIdx);
        }
        byte[] b = new byte[this.buffer.length - 1 - endIdx];
        System.arraycopy(this.buffer, endIdx + 1, b, 0, b.length);
        this.buffer = b;
    }
}

