/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrstampy.esp.openbci.rxtx;

import com.github.mrstampy.esp.openbci.OpenBCIConstants;
import com.github.mrstampy.esp.openbci.rxtx.RxtxDataBuffer;
import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class RxtxDataBufferTest
implements OpenBCIConstants {
    private RxtxDataBuffer buffer = new RxtxDataBuffer();
    private int numChannels = 3;

    @After
    public void after() throws Exception {
        this.buffer.clear();
    }

    @Test
    public void testMultipleMessages() throws Exception {
        int expected = 3;
        int i = 0;
        while (i < expected) {
            this.buffer.add(this.getFullMessage());
            ++i;
        }
        int cnt = 0;
        byte[] msg = this.buffer.get();
        while (msg != null) {
            Assert.assertTrue((boolean)this.isValidMessage(msg));
            ++cnt;
            msg = this.buffer.get();
        }
        Assert.assertTrue((cnt == expected ? 1 : 0) != 0);
        Assert.assertTrue((this.buffer.getBufferCopy().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSplitMessage() throws Exception {
        this.buffer.add(this.getHeader());
        byte[] msg = this.buffer.get();
        Assert.assertNull((Object)msg);
        this.buffer.add(this.getData());
        msg = this.buffer.get();
        Assert.assertNull((Object)msg);
        this.buffer.add(-64);
        this.buffer.add(this.getHeader());
        msg = this.buffer.get();
        Assert.assertNotNull((Object)msg);
        Assert.assertTrue((boolean)this.isValidMessage(msg));
        msg = this.buffer.get();
        Assert.assertNull((Object)msg);
        Assert.assertTrue((this.buffer.getBufferCopy().length == 2 ? 1 : 0) != 0);
        this.buffer.add(this.getData());
        this.buffer.add(-64);
        msg = this.buffer.get();
        Assert.assertNotNull((Object)msg);
        Assert.assertTrue((boolean)this.isValidMessage(msg));
        Assert.assertTrue((this.buffer.getBufferCopy().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBrokenMessages() throws Exception {
        this.buffer.add(this.getHeader());
        this.buffer.add(this.getHeader());
        this.buffer.add(this.getHeader());
        this.buffer.add(this.getData());
        this.buffer.add(-64);
        byte[] msg = this.buffer.get();
        Assert.assertNotNull((Object)msg);
        Assert.assertTrue((boolean)this.isValidMessage(msg));
        Assert.assertTrue((this.buffer.getBufferCopy().length == 0 ? 1 : 0) != 0);
        this.buffer.add(this.getHeader());
        this.buffer.add(this.getData());
        this.buffer.add(this.getData());
        this.buffer.add(-64);
        msg = this.buffer.get();
        Assert.assertNotNull((Object)msg);
        Assert.assertTrue((!this.isValidMessage(msg) ? 1 : 0) != 0);
        Assert.assertTrue((this.buffer.getBufferCopy().length == 0 ? 1 : 0) != 0);
        this.buffer.add(this.getHeader());
        this.buffer.add(this.getHeader());
        this.buffer.add(this.getData());
        this.buffer.add(this.getData());
        this.buffer.add(-64);
        this.buffer.add(-64);
        this.buffer.add(-64);
        msg = this.buffer.get();
        Assert.assertNotNull((Object)msg);
        Assert.assertTrue((!this.isValidMessage(msg) ? 1 : 0) != 0);
        Assert.assertTrue((this.buffer.getBufferCopy().length == 2 ? 1 : 0) != 0);
        this.buffer.add(this.getHeader());
        this.buffer.add(this.getHeader());
        this.buffer.add(this.getData());
        this.buffer.add(-64);
        msg = this.buffer.get();
        Assert.assertNotNull((Object)msg);
        Assert.assertTrue((boolean)this.isValidMessage(msg));
        Assert.assertTrue((this.buffer.getBufferCopy().length == 0 ? 1 : 0) != 0);
    }

    private boolean isValidMessage(byte[] msg) {
        if (msg == null || msg.length != this.getFullMessageSize()) {
            return false;
        }
        return msg[0] == -96 && msg[msg.length - 1] == -64 && msg[1] == this.numChannels;
    }

    private byte[] getHeader() {
        byte[] b = new byte[]{-96, (byte)this.numChannels};
        return b;
    }

    private byte[] getData() {
        byte[] b = new byte[this.numChannels * 4];
        Arrays.fill(b, (byte)1);
        return b;
    }

    private int getFullMessageSize() {
        return 3 + 4 * this.numChannels;
    }

    private byte[] getFullMessage() {
        byte[] msg = new byte[this.getFullMessageSize()];
        Arrays.fill(msg, (byte)1);
        msg[0] = -96;
        msg[1] = (byte)this.numChannels;
        msg[msg.length - 1] = -64;
        return msg;
    }
}

