/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrstampy.esplab.gui;

import com.github.mrstampy.esp.dsp.lab.RawEspConnection;
import com.github.mrstampy.esp.multiconnectionsocket.ConnectionEvent;
import com.github.mrstampy.esp.multiconnectionsocket.ConnectionEventListener;
import com.github.mrstampy.esp.multiconnectionsocket.MultiConnectionSocketException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.event.EventType;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Control;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import org.controlsfx.dialog.Dialogs;
import org.reactfx.EventStreams;
import org.reactfx.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Scheduler;
import rx.functions.Action1;
import rx.schedulers.Schedulers;

public abstract class AbstractGraph<XAXIS>
implements ConnectionEventListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractGraph.class);
    private RawEspConnection connection;
    private Subscription subscription;
    protected XYChart<XAXIS, Number> chart;
    protected XYChart.Series<XAXIS, Number> series = new XYChart.Series();
    protected Axis<XAXIS> xAxis;
    protected NumberAxis yAxis = new NumberAxis();
    protected ToggleButton startStop;
    protected AtomicBoolean running = new AtomicBoolean(false);
    protected Scheduler scheduler = Schedulers.io();
    private rx.Subscription snap;
    private AtomicBoolean errorShowing = new AtomicBoolean();

    public AbstractGraph() {
        this.initButtons();
    }

    public void connectionEventPerformed(ConnectionEvent e) {
        switch (e.getState()) {
            case STARTED: {
                this.preStart();
                this.start();
                break;
            }
            case STOPPED: {
                this.preStop();
                this.stop();
                break;
            }
            case ERROR_STOPPED: 
            case ERROR_UNBOUND: {
                this.preStop();
                this.stop();
                this.connectionError(e.getState());
                break;
            }
        }
    }

    protected void toolTip(Control node, String tip) {
        node.setTooltip(new Tooltip(tip));
    }

    private void preStop() {
        this.running.set(false);
        if (this.snap != null) {
            this.snap.unsubscribe();
        }
        if (this.startStop.isSelected()) {
            this.startStop.setSelected(false);
            this.startStop.setText("Start");
        }
    }

    protected void preStart() {
        this.running.set(true);
        this.snap = this.scheduler.schedulePeriodically((Action1)new Action1<Scheduler.Inner>(){

            public void call(Scheduler.Inner t1) {
                try {
                    if (AbstractGraph.this.getConnection() == null) {
                        AbstractGraph.this.snap.unsubscribe();
                    } else {
                        AbstractGraph.this.graphAccept(AbstractGraph.this.getConnection().getCurrentFor(AbstractGraph.this.getChannel()));
                    }
                }
                catch (Throwable e) {
                    log.error("Unexpected exception", e);
                }
            }
        }, 250L, 250L, TimeUnit.MILLISECONDS);
        if (!this.startStop.isSelected()) {
            this.startStop.setSelected(true);
            this.startStop.setText("Stop");
        }
    }

    protected abstract int getChannel();

    public abstract Region getLayout();

    protected void connectionError(ConnectionEvent.State state) {
        this.showConnectionError(this.getLostConnectionMasthead());
    }

    protected abstract void start();

    protected abstract void stop();

    protected Pane getButtons() {
        HBox box = new HBox(10.0);
        box.setAlignment(Pos.CENTER);
        box.getChildren().addAll((Object[])new Node[]{this.startStop});
        return box;
    }

    public RawEspConnection getConnection() {
        return this.connection;
    }

    public void setConnection(RawEspConnection connection) {
        this.preSetConnection();
        this.connection = connection;
        this.postSetConnection();
    }

    protected void preSetConnection() {
        if (this.connection == null) {
            return;
        }
        this.connection.removeConnectionEventListener((ConnectionEventListener)this);
        if (this.subscription != null) {
            this.subscription.unsubscribe();
        }
    }

    protected void postSetConnection() {
        if (this.connection == null) {
            return;
        }
        this.getConnection().addConnectionEventListener((ConnectionEventListener)this);
        if (this.getConnection().isConnected()) {
            this.preStart();
            this.start();
        }
    }

    protected abstract void graphAccept(double[][] var1);

    private void initButtons() {
        this.startStop = new ToggleButton("Start");
        EventStreams.eventsOf((Node)this.startStop, (EventType)MouseEvent.MOUSE_CLICKED).subscribe(t -> this.startStop());
        this.toolTip((Control)this.startStop, "Start / stop the ESP device");
    }

    protected void startStop() {
        if (this.startStop.isSelected()) {
            this.startButtonClicked();
        } else {
            this.stopButtonClicked();
        }
    }

    private void stopButtonClicked() {
        if (this.getConnection().isConnected()) {
            this.getConnection().stop();
        }
        this.startStop.setText("Start");
        if (this.startStop.isSelected()) {
            this.startStop.setSelected(false);
        }
    }

    private void startButtonClicked() {
        try {
            this.getConnection().start();
            this.startStop.setText("Stop");
        }
        catch (MultiConnectionSocketException e) {
            log.error("Unexpected exception starting connection", (Throwable)e);
            this.showConnectionError(this.getMasthead());
        }
    }

    protected void showConnectionError(String masthead) {
        if (this.errorShowing.get()) {
            return;
        }
        if (Platform.isFxApplicationThread()) {
            this.connectionError(masthead);
        } else {
            Platform.runLater(() -> this.connectionError(masthead));
        }
    }

    private void connectionError(String masthead) {
        this.errorShowing.set(true);
        this.stopButtonClicked();
        Dialogs.create().masthead(masthead).title("Device Unavailable").owner((Object)this.startStop).showError();
        this.errorShowing.set(false);
    }

    private String getMasthead() {
        return "Could not connect to the " + this.getConnection().getName() + ". Set/reset the connection and try again.";
    }

    private String getLostConnectionMasthead() {
        return "Lost connection to the " + this.getConnection().getName() + ". Reset the connection and try again.";
    }
}

