/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrstampy.esplab.gui;

import com.github.mrstampy.esp.dsp.lab.EspWindowFunction;
import com.github.mrstampy.esp.dsp.lab.FFTType;
import com.github.mrstampy.esp.dsp.lab.Lab;
import com.github.mrstampy.esp.dsp.lab.PassFilter;
import com.github.mrstampy.esplab.gui.AbstractGraph;
import com.sun.javafx.collections.ObservableListWrapper;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import org.controlsfx.control.MasterDetailPane;
import org.controlsfx.control.RangeSlider;
import rx.Observable;

public class PowerGraph
extends AbstractGraph<String> {
    private ComboBox<FFTType> fftType = new ComboBox();
    private Button calculateBaseline = new Button("Calculate Baseline");
    private Button clearBaseline = new Button("Clear Baseline");
    private CheckBox displayGraph = new CheckBox("Display Graph");
    private ComboBox<EspWindowFunction> functions = new ComboBox();
    private ComboBox<PassFilter> filters = new ComboBox();
    private CheckBox normalizeSignal = new CheckBox("Normalize Signal");
    private CheckBox normalizeFft = new CheckBox("Normalize FFT");
    private CheckBox absoluteValues = new CheckBox("Absolute Values");
    private RangeSlider bandPassSlider = new RangeSlider(1.0, 40.0, 1.0, 40.0);
    private Slider highPassFactor = new Slider(1.0, 50.0, 1.0);
    private Slider lowPassFactor = new Slider(1.0, 50.0, 1.0);
    private TextField lowVal = new TextField();
    private TextField highVal = new TextField();
    private Lab lab;
    private AtomicBoolean graphing = new AtomicBoolean(true);

    public PowerGraph(Lab lab) {
        this.setLab(lab);
        lab.addSignalProcessedListener(t -> this.plot(t));
        this.initChart();
        this.initComboBoxes();
        this.initCheckboxes();
        this.initSliders();
        this.initButtons();
        this.fftSelected();
        this.filterSelected();
        this.toolTips();
    }

    private void toolTips() {
        this.toolTip((Control)this.fftType, "Choose the type of FFT to apply to the signal");
        this.toolTip((Control)this.calculateBaseline, "Calculate a baseline for the signal");
        this.toolTip((Control)this.clearBaseline, "Clear the current baseline from the signal");
        this.toolTip((Control)this.displayGraph, "Display or suppress graphing of the processed signal");
        this.toolTip((Control)this.functions, "Choose the window function to apply to the signal (for real & log FFT's)");
        this.toolTip((Control)this.filters, "Choose the pass filter to apply to the signal");
        this.toolTip((Control)this.normalizeFft, "Normalize the FFT values");
        this.toolTip((Control)this.absoluteValues, "Use absolute values");
        this.toolTip((Control)this.bandPassSlider, "Select the value or range for the pass filters");
        this.toolTip((Control)this.normalizeSignal, "Normalize the input signal");
        this.toolTip((Control)this.highPassFactor, "High pass factor");
        this.toolTip((Control)this.lowPassFactor, "Low pass factor");
    }

    private void initButtons() {
        this.calculateBaseline.addEventHandler(ActionEvent.ACTION, t -> this.calculateBaselineClicked());
        this.calculateBaseline.setDisable(this.getConnection() == null || !this.getConnection().isConnected());
        this.clearBaseline.addEventHandler(ActionEvent.ACTION, t -> this.clearBaselineClicked());
        this.setClearBaselineEffect();
        this.displayGraph.addEventHandler(ActionEvent.ACTION, t -> this.displayGraphClicked());
        this.displayGraph.fire();
    }

    private void setClearBaselineEffect() {
        this.clearBaseline.setEffect(this.getLab().getBaseline() == 0.0 ? null : this.getBaselineEffect());
    }

    private Effect getBaselineEffect() {
        return new DropShadow(10.0, Color.GOLD);
    }

    private void displayGraphClicked() {
        this.graphing.set(this.displayGraph.isSelected());
        if (!this.graphing.get()) {
            this.reset();
        }
    }

    private void clearBaselineClicked() {
        this.getLab().resetBaseline();
        this.setClearBaselineEffect();
    }

    private void calculateBaselineClicked() {
        this.calculateBaseline.setDisable(true);
        this.calculateBaseline.setText("Calculating...");
        this.getLab().calculateBaseline();
        Observable.timer((long)10L, (TimeUnit)TimeUnit.SECONDS).subscribe(a -> Platform.runLater(() -> this.setBaseline()));
    }

    private void setBaseline() {
        this.getLab().stopCalculateBaseline();
        this.calculateBaseline.setDisable(false);
        this.calculateBaseline.setText("Calculate Baseline");
        this.setClearBaselineEffect();
    }

    private void initSliders() {
        this.initSlider(this.bandPassSlider);
        this.initSlider(this.highPassFactor);
        this.initSlider(this.lowPassFactor);
        this.bandPassSlider.lowValueProperty().addListener((o, old, newVal) -> this.lowBandPassValueChanged(newVal.doubleValue()));
        this.bandPassSlider.highValueProperty().addListener((o, old, newVal) -> this.highBandPassValueChanged(newVal.doubleValue()));
        this.highPassFactor.valueProperty().addListener((o, old, newVal) -> this.highFactorChanged(newVal.doubleValue()));
        this.lowPassFactor.valueProperty().addListener((o, old, newVal) -> this.lowFactorChanged(newVal.doubleValue()));
        this.lowVal.setMaxWidth(50.0);
        this.lowVal.setEditable(false);
        this.highVal.setMaxWidth(50.0);
        this.highVal.setEditable(false);
        this.bandPassSlider.setLowValue(this.getLab().getLowPassFrequency());
        this.lowVal.setText(Double.toString(this.getLab().getLowPassFrequency()));
        double high = this.getLab().getHighPassFrequency() > this.bandPassSlider.getMax() ? this.bandPassSlider.getMax() : this.getLab().getHighPassFrequency();
        this.bandPassSlider.setHighValue(high);
        this.highVal.setText(Double.toString(high));
        this.highPassFactor.setValue(this.getLab().getHighPassFilterFactor());
        this.lowPassFactor.setValue(this.getLab().getLowPassFilterFactor());
    }

    private void lowFactorChanged(double d) {
        this.getLab().setLowPassFilterFactor(d);
    }

    private void highFactorChanged(double d) {
        this.getLab().setHighPassFilterFactor(d);
    }

    private void initSlider(Slider slider) {
        slider.setShowTickLabels(false);
        slider.setShowTickMarks(false);
        slider.setMinWidth(500.0);
    }

    private void highBandPassValueChanged(double val) {
        this.getLab().setHighPassFrequency(val);
        this.highVal.setText(Double.toString(val));
    }

    private void lowBandPassValueChanged(double val) {
        this.getLab().setLowPassFrequency(val);
        this.lowVal.setText(Double.toString(val));
    }

    private void initSlider(RangeSlider slider) {
        slider.setShowTickMarks(true);
        slider.setSnapToPixel(true);
        slider.setSnapToTicks(true);
        slider.setMajorTickUnit(1.0);
        slider.setMinWidth(400.0);
        slider.setBlockIncrement(1.0);
    }

    private void initCheckboxes() {
        this.normalizeFft.addEventHandler(ActionEvent.ACTION, t -> this.normalizeFftSelected());
        this.normalizeFft.setSelected(this.getLab().isNormalizeFft());
        this.normalizeSignal.addEventHandler(ActionEvent.ACTION, t -> this.normalizeSignalSelected());
        this.normalizeSignal.setSelected(this.getLab().isNormalizeSignal());
        this.absoluteValues.addEventHandler(ActionEvent.ACTION, t -> this.absoluteValuesSelected());
        this.absoluteValues.setSelected(this.getLab().isAbsoluteValues());
    }

    private void absoluteValuesSelected() {
        this.getLab().setAbsoluteValues(this.absoluteValues.isSelected());
    }

    private void normalizeSignalSelected() {
        this.getLab().setNormalizeSignal(this.normalizeSignal.isSelected());
    }

    private void normalizeFftSelected() {
        this.getLab().setNormalizeFft(this.normalizeFft.isSelected());
        this.setAbsoluteEnabled();
    }

    private void initComboBoxes() {
        this.functions.setItems((ObservableList)new ObservableListWrapper(Arrays.asList(EspWindowFunction.values())));
        this.functions.setValue((Object)this.getConnection().getWindowFunction());
        this.functions.addEventHandler(ActionEvent.ACTION, t -> this.getConnection().setWindowFunction((EspWindowFunction)this.functions.getValue()));
        this.filters.setItems((ObservableList)new ObservableListWrapper(Arrays.asList(PassFilter.values())));
        this.filters.setValue((Object)this.getLab().getPassFilter());
        this.filters.addEventHandler(ActionEvent.ACTION, t -> this.filterSelected());
        this.fftType.setItems((ObservableList)new ObservableListWrapper(Arrays.asList(FFTType.values())));
        this.fftType.setValue((Object)this.getLab().getFftType());
        this.fftType.addEventHandler(ActionEvent.ACTION, t -> this.fftSelected());
    }

    private void fftSelected() {
        this.setAbsoluteEnabled();
        this.setNormalizeFftEnabled();
        this.getLab().setFftType((FFTType)this.fftType.getValue());
    }

    private void setNormalizeFftEnabled() {
        boolean disable = this.fftType.getValue() == FFTType.no_fft;
        this.normalizeFft.setDisable(disable);
    }

    private void filterSelected() {
        this.getLab().setPassFilter((PassFilter)this.filters.getValue());
        this.setBandPassSliderEnabled();
    }

    private void setBandPassSliderEnabled() {
        PassFilter filter = (PassFilter)this.filters.getValue();
        boolean disable = filter == PassFilter.no_pass_filter;
        boolean disLow = filter == PassFilter.high_pass || disable;
        boolean disHigh = filter == PassFilter.low_pass || disable;
        this.setSliderEnabled((Node)this.bandPassSlider, disable, disable ? 0.5 : 1.0);
        this.setSliderEnabled((Node)this.highPassFactor, disHigh, disHigh ? 0.5 : 1.0);
        this.setSliderEnabled((Node)this.lowPassFactor, disLow, disLow ? 0.5 : 1.0);
        this.setTextBackground(this.lowVal, disHigh);
        this.setTextBackground(this.highVal, disLow);
    }

    private void setTextBackground(TextField field, boolean disable) {
        String s = disable ? "white" : "lightblue";
        field.setStyle("-fx-background-color: " + s);
    }

    private void setSliderEnabled(Node node, boolean disable, double opacity) {
        node.setDisable(disable);
        node.setOpacity(opacity);
    }

    private void setAbsoluteEnabled() {
        boolean disable = FFTType.log_fft == this.fftType.getValue() || this.normalizeFft.isSelected();
        this.absoluteValues.setDisable(disable);
    }

    private void initChart() {
        CategoryAxis ca = new CategoryAxis();
        this.xAxis = ca;
        this.xAxis.setAutoRanging(true);
        this.yAxis.setAutoRanging(true);
        BarChart bc = new BarChart(this.xAxis, (Axis)this.yAxis);
        this.chart = bc;
        this.chart.setTitle("Power");
        this.chart.setAnimated(false);
        this.chart.setMinWidth(900.0);
        this.chart.setHorizontalGridLinesVisible(false);
        this.chart.setVerticalGridLinesVisible(false);
        bc.setBarGap(0.0);
        bc.setCategoryGap(2.0);
        this.series.setName("Frequency (Hz)");
        int i = 1;
        while (i <= 40) {
            this.series.getData().add((Object)new XYChart.Data((Object)Integer.toString(i), (Object)0));
            ++i;
        }
        this.chart.getData().add((Object)this.series);
    }

    @Override
    public Region getLayout() {
        MasterDetailPane pane = new MasterDetailPane(Side.BOTTOM);
        pane.setMinWidth(1000.0);
        pane.setDividerPosition(0.5);
        pane.setMasterNode((Node)this.chart);
        VBox box = new VBox(10.0);
        box.setAlignment(Pos.CENTER);
        box.getChildren().addAll((Object[])new Node[]{this.displayGraph, this.getPreFftPane()});
        Pane buttons = this.getButtons();
        buttons.getChildren().addAll((Object[])new Node[]{this.calculateBaseline, this.clearBaseline});
        box.getChildren().addAll((Object[])new Node[]{buttons});
        pane.setDetailNode((Node)box);
        return pane;
    }

    public Lab getLab() {
        return this.lab;
    }

    @Override
    protected int getChannel() {
        return this.getLab().getChannel();
    }

    public void setLab(Lab lab) {
        this.lab = lab;
        this.setConnection(lab.getConnection());
    }

    private GridPane getPreFftPane() {
        GridPane gp = new GridPane();
        Label wf = new Label("Window Functions");
        Label pf = new Label("Pass Filters");
        Label lbl = new Label("Pass Filter Frequencies");
        Label fft = new Label("FFT Type");
        GridHelper gh = new GridHelper();
        this.gridify(gh, (Node)fft, HPos.RIGHT, VPos.CENTER);
        gh.incrX();
        this.gridify(gh, (Node)this.fftType, HPos.LEFT, VPos.CENTER);
        gh.incrX();
        this.gridify(gh, (Node)this.normalizeFft, HPos.LEFT, VPos.CENTER);
        gh.newLine();
        this.gridify(gh, (Node)wf, HPos.RIGHT, VPos.CENTER);
        gh.incrX();
        this.gridify(gh, (Node)this.functions, HPos.LEFT, VPos.CENTER);
        gh.incrX();
        this.gridify(gh, (Node)this.absoluteValues, HPos.LEFT, VPos.CENTER);
        gh.newLine();
        this.gridify(gh, (Node)pf, HPos.RIGHT, VPos.CENTER);
        gh.incrX();
        this.gridify(gh, (Node)this.filters, HPos.LEFT, VPos.CENTER);
        gh.incrX();
        this.gridify(gh, (Node)this.normalizeSignal, HPos.LEFT, VPos.CENTER);
        gh.width = 3;
        gh.newLine();
        this.gridify(gh, (Node)lbl, HPos.CENTER, VPos.CENTER);
        gh.newLine();
        HBox bp = this.getBandPassBox();
        this.gridify(gh, (Node)bp, HPos.CENTER, VPos.CENTER);
        gh.newLine();
        this.gridify(gh, (Node)this.highPassFactor, HPos.CENTER, VPos.CENTER);
        gh.newLine();
        this.gridify(gh, (Node)this.lowPassFactor, HPos.CENTER, VPos.CENTER);
        gp.setAlignment(Pos.CENTER);
        gp.getChildren().addAll((Object[])new Node[]{fft, this.fftType, this.displayGraph, wf, this.functions, pf, this.filters, this.absoluteValues, lbl, bp, this.normalizeSignal, this.normalizeFft, this.highPassFactor, this.lowPassFactor});
        return gp;
    }

    private HBox getBandPassBox() {
        HBox box = new HBox(10.0);
        box.getChildren().addAll((Object[])new Node[]{this.lowVal, this.bandPassSlider, this.highVal});
        return box;
    }

    private void gridify(GridHelper gh, Node node, HPos hPos, VPos vPos) {
        GridPane.setConstraints((Node)node, (int)gh.x, (int)gh.y, (int)gh.width, (int)gh.height, (HPos)hPos, (VPos)vPos, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(5.0));
    }

    @Override
    protected void start() {
        this.calculateBaseline.setDisable(false);
    }

    @Override
    protected void stop() {
        Observable.timer((long)50L, (TimeUnit)TimeUnit.MILLISECONDS).subscribe(a -> this.reset());
        if (!this.startStop.isSelected()) {
            this.startStop.setSelected(false);
            this.startStop();
        }
        this.calculateBaseline.setDisable(true);
    }

    @Override
    protected void postSetConnection() {
        if (this.getConnection() == null) {
            return;
        }
        super.postSetConnection();
        this.getLab().setConnection(this.getConnection());
    }

    @Override
    protected void graphAccept(double[][] samples) {
        Observable.just((Object)samples).subscribe(t1 -> this.getLab().process(t1));
    }

    private void reset() {
        double[] zero = new double[this.getLab().getNumBands()];
        Arrays.fill(zero, 0.0);
        Platform.runLater(() -> this.paintPowers(zero));
    }

    private void plot(double[] wmad) {
        if (this.graphing.get()) {
            Platform.runLater(() -> this.paintPowers(wmad));
        }
    }

    private void paintPowers(double[] wmad) {
        ObservableList data = this.series.getData();
        int i = 0;
        while (i < wmad.length - 1) {
            XYChart.Data point = (XYChart.Data)data.get(i);
            point.setYValue((Object)wmad[i + 1]);
            ++i;
        }
    }

    class GridHelper {
        int x;
        int y;
        int width = 1;
        int height = 1;

        GridHelper() {
        }

        void incrX() {
            ++this.x;
        }

        void incrY() {
            ++this.y;
        }

        void newLine() {
            this.incrY();
            this.x = 0;
        }

        void resetWH() {
            this.width = 1;
            this.height = 1;
        }
    }
}

