/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrstampy.esplab.gui;

import com.github.mrstampy.esplab.gui.AbstractGraph;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.controlsfx.control.MasterDetailPane;
import rx.Observable;

public class RawDataGraph
extends AbstractGraph<Number> {
    private static final int MAX_X = 100;
    private AnimationTimer timer;
    private AtomicInteger counter = new AtomicInteger();
    private AtomicInteger xPos = new AtomicInteger();
    private ArrayBlockingQueue<Double> queue = new ArrayBlockingQueue(10000);

    public RawDataGraph() {
        this.initChart();
    }

    @Override
    public Region getLayout() {
        MasterDetailPane pane = new MasterDetailPane(Side.BOTTOM);
        pane.setMinWidth(1000.0);
        pane.setDividerPosition(0.8);
        pane.setMasterNode((Node)this.chart);
        VBox box = new VBox(10.0, new Node[]{this.startStop});
        box.setAlignment(Pos.CENTER);
        pane.setDetailNode((Node)box);
        return pane;
    }

    @Override
    protected void graphAccept(double[][] t) {
        if (!this.running.get() || t.length == 0) {
            return;
        }
        if (this.counter.get() % 4 == 0) {
            int i = 0;
            while (i < t[0].length) {
                this.queue.add(t[0][i]);
                ++i;
            }
        }
        this.counter.getAndIncrement();
    }

    @Override
    protected void start() {
        this.counter.set(0);
        this.queue.clear();
        this.series.getData().clear();
        this.xPos.set(0);
        this.timer.start();
    }

    @Override
    protected void stop() {
        this.timer.stop();
    }

    private void initChart() {
        NumberAxis na = new NumberAxis();
        this.xAxis = na;
        this.xAxis.setAutoRanging(true);
        na.setForceZeroInRange(false);
        na.setMinorTickVisible(false);
        this.xAxis.setTickMarkVisible(false);
        this.xAxis.setTickLabelsVisible(false);
        this.yAxis.setAutoRanging(true);
        this.chart = new LineChart((Axis)na, (Axis)this.yAxis);
        this.chart.setTitle("Raw Data");
        this.chart.setAnimated(false);
        this.chart.setHorizontalGridLinesVisible(false);
        this.chart.setVerticalGridLinesVisible(false);
        this.series.setName("Raw Data");
        this.chart.getData().add((Object)this.series);
        this.timer = new AnimationTimer(){

            public void handle(long arg0) {
                ArrayList list = new ArrayList();
                RawDataGraph.this.queue.drainTo(list);
                list.forEach(t -> RawDataGraph.this.updateChartImpl(t));
            }
        };
    }

    private void updateChartImpl(double val) {
        Observable.timer((long)100L, (TimeUnit)TimeUnit.MICROSECONDS).subscribe(t -> Platform.runLater(() -> this.updateChart(val)));
    }

    private void updateChart(double val) {
        ObservableList data = this.series.getData();
        data.add((Object)new XYChart.Data((Object)this.xPos.getAndIncrement(), (Object)val));
        if (data.size() > 100) {
            data.remove(0, data.size() - 100);
        }
        int x = this.xPos.get();
        NumberAxis na = (NumberAxis)this.xAxis;
        na.setLowerBound((double)(x - 100));
        na.setUpperBound((double)x);
    }

    @Override
    protected int getChannel() {
        return 1;
    }
}

