/*
 * Decompiled with CFR 0.152.
 */
package com.github.msarhan.ummalqura.calendar;

import java.util.Arrays;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

class UmmalquraDateFormatSymbols {
    Locale locale = null;
    String[] months = null;
    String[] shortMonths = null;

    public UmmalquraDateFormatSymbols() {
        this.initializeData(Locale.getDefault(Locale.Category.FORMAT));
    }

    public UmmalquraDateFormatSymbols(Locale locale) {
        this.initializeData(locale);
    }

    public String[] getMonths() {
        return Arrays.copyOf(this.months, this.months.length);
    }

    public String[] getShortMonths() {
        return Arrays.copyOf(this.shortMonths, this.shortMonths.length);
    }

    private void initializeData(Locale desiredLocale) {
        this.locale = desiredLocale;
        ResourceBundle resource = ResourceBundle.getBundle("com.github.msarhan.ummalqura.calendar.text.UmmalquraFormatData", this.locale, new ResourceBundle.Control(){

            @Override
            public Locale getFallbackLocale(String baseName, Locale locale) {
                return Locale.ENGLISH;
            }
        });
        if (ListResourceBundle.class.isAssignableFrom(resource.getClass())) {
            this.months = resource.getStringArray("MonthNames");
            this.shortMonths = resource.getStringArray("MonthAbbreviations");
        } else if (PropertyResourceBundle.class.isAssignableFrom(resource.getClass())) {
            this.months = resource.getString("MonthNames").split(",");
            this.shortMonths = resource.getString("MonthAbbreviations").split(",");
        }
    }
}

