/*
 * Decompiled with CFR 0.152.
 */
package com.github.msarhan.ummalqura.calendar;

import com.github.msarhan.ummalqura.calendar.HijrahChronology;
import com.github.msarhan.ummalqura.calendar.UmmalquraDateFormatSymbols;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class UmmalquraCalendar
extends GregorianCalendar {
    public static final int MUHARRAM = 0;
    public static final int SAFAR = 1;
    public static final int RABI_AWWAL = 2;
    public static final int RABI_THANI = 3;
    public static final int JUMADA_AWWAL = 4;
    public static final int JUMADA_THANI = 5;
    public static final int RAJAB = 6;
    public static final int SHAABAN = 7;
    public static final int RAMADHAN = 8;
    public static final int SHAWWAL = 9;
    public static final int THUL_QIDAH = 10;
    public static final int THUL_HIJJAH = 11;
    protected int[] hFields;
    private boolean isSetYear = false;
    private boolean isSetMonth = false;
    private boolean isSetDayOfMonth = false;

    public UmmalquraCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public UmmalquraCalendar(Locale aLocale) {
        this(TimeZone.getDefault(), aLocale);
    }

    public UmmalquraCalendar(TimeZone zone, Locale aLocale) {
        super(zone, aLocale);
    }

    public UmmalquraCalendar(int year, int month, int dayOfMonth) {
        this(year, month, dayOfMonth, 0, 0, 0);
    }

    public UmmalquraCalendar(int year, int month, int dayOfMonth, int hourOfDay, int minute) {
        this(year, month, dayOfMonth, hourOfDay, minute, 0);
    }

    public UmmalquraCalendar(int year, int month, int dayOfMonth, int hourOfDay, int minute, int second) {
        this.set(1, year);
        this.set(2, month);
        this.set(5, dayOfMonth);
        this.set(11, hourOfDay);
        this.set(12, minute);
        this.set(13, second);
    }

    public static int lengthOfMonth(int year, int month) {
        return HijrahChronology.getDaysInMonth(year, month + 1);
    }

    public static int lengthOfYear(int year) {
        int total = 0;
        for (int m = 0; m <= 11; ++m) {
            total += UmmalquraCalendar.lengthOfMonth(year, m);
        }
        return total;
    }

    @Override
    public int get(int field) {
        if (field == 1 || field == 2 || field == 5) {
            return this.hFields[field];
        }
        return super.get(field);
    }

    @Override
    public void set(int field, int value) {
        if (field == 1 || field == 2 || field == 5) {
            int[] hDateInfo = HijrahChronology.toHijri(this.getTime());
            if (field == 1) {
                hDateInfo[0] = value;
                this.isSetYear = true;
            } else if (field == 2) {
                hDateInfo[1] = value;
                this.isSetMonth = true;
            } else {
                hDateInfo[2] = value;
                this.isSetDayOfMonth = true;
            }
            this.adjustFields(hDateInfo);
            int[] gDateInfo = HijrahChronology.toGregorian(hDateInfo[0], hDateInfo[1], hDateInfo[2]);
            super.set(1, gDateInfo[0]);
            super.set(2, gDateInfo[1]);
            super.set(5, gDateInfo[2]);
            this.complete();
        } else {
            super.set(field, value);
        }
    }

    private void adjustFields(int[] hDateInfo) {
        if (hDateInfo[2] == 30 && HijrahChronology.INSTANCE.getMonthLength(hDateInfo[0], hDateInfo[1] + 1) < 30) {
            if (!this.isSetMonth) {
                hDateInfo[1] = 0;
            }
            if (!this.isSetYear) {
                hDateInfo[0] = 1300;
            }
        }
    }

    public int lengthOfMonth() {
        return UmmalquraCalendar.lengthOfMonth(this.get(1), this.get(2));
    }

    public int lengthOfYear() {
        return UmmalquraCalendar.lengthOfYear(this.get(1));
    }

    @Override
    public String getDisplayName(int field, int style, Locale locale) {
        if (field == 2) {
            int fieldValue;
            UmmalquraDateFormatSymbols symbols = new UmmalquraDateFormatSymbols(locale);
            String[] strings = this.getFieldStrings(field, style, symbols);
            if (strings != null && (fieldValue = this.get(field)) < strings.length) {
                return strings[fieldValue];
            }
            return null;
        }
        return super.getDisplayName(field, style, locale);
    }

    @Override
    public Map<String, Integer> getDisplayNames(int field, int style, Locale locale) {
        if (field == 2) {
            if (style == 0) {
                Map<String, Integer> shortNames = this.getDisplayNamesImpl(field, 1, locale);
                Map<String, Integer> longNames = this.getDisplayNamesImpl(field, 2, locale);
                if (shortNames == null) {
                    return longNames;
                }
                if (longNames != null) {
                    shortNames.putAll(longNames);
                }
                return shortNames;
            }
            return this.getDisplayNamesImpl(field, style, locale);
        }
        return super.getDisplayNames(field, style, locale);
    }

    private Map<String, Integer> getDisplayNamesImpl(int field, int style, Locale locale) {
        UmmalquraDateFormatSymbols symbols = new UmmalquraDateFormatSymbols(locale);
        String[] strings = this.getFieldStrings(field, style, symbols);
        if (strings != null) {
            HashMap<String, Integer> names = new HashMap<String, Integer>();
            for (int i = 0; i < strings.length; ++i) {
                if (strings[i].length() == 0) continue;
                names.put(strings[i], i);
            }
            return names;
        }
        return null;
    }

    private String[] getFieldStrings(int field, int style, UmmalquraDateFormatSymbols symbols) {
        if (field == 2) {
            if (1 == style) {
                return symbols.getShortMonths();
            }
            if (2 == style) {
                return symbols.getMonths();
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof UmmalquraCalendar && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ 0x26E;
    }

    @Override
    protected void computeFields() {
        super.computeFields();
        if (this.hFields == null) {
            this.hFields = new int[this.fields.length];
        }
        int[] hDateInfo = HijrahChronology.toHijri(new Date(this.time));
        this.hFields[1] = hDateInfo[0];
        this.hFields[2] = hDateInfo[1];
        this.hFields[5] = hDateInfo[2];
    }
}

