/*
 * Decompiled with CFR 0.152.
 */
package com.msimw.mcache.aop;

import com.msimw.mcache.annotation.CacheEvict;
import com.msimw.mcache.annotation.CacheEvicts;
import com.msimw.mcache.annotation.Cacheable;
import com.msimw.mcache.annotation.Cached;
import com.msimw.mcache.handler.CacheHandler;
import com.msimw.mcache.handler.bean.CacheTarget;
import com.msimw.mcache.handler.bean.Parameter;
import com.msimw.mcache.util.clasz.ClassUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.CollectionUtils;

public class CacheInterceptor {
    private static final Log LOGGER = LogFactory.getLog(CacheInterceptor.class);
    private CacheHandler defaultCacheHandler;
    private Map<String, CacheHandler> cacheHandlerMap;

    public Object cache(ProceedingJoinPoint jp) throws Throwable {
        try {
            Cacheable cacheable = (Cacheable)AnnotationUtils.findAnnotation((Method)((MethodSignature)jp.getSignature()).getMethod(), Cacheable.class);
            return this.getCacheHandler(cacheable.cache()).handler(this.buildCacheTarget((JoinPoint)jp, cacheable));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.warn((Object)("\u7edf\u4e00\u7f13\u5b58,\u7edf\u4e00\u7f13\u5b58\u4ee3\u7406,\u7f13\u5b58\u51fa\u9519,e:" + e.getClass()));
            return jp.proceed();
        }
    }

    public void update(JoinPoint jp) throws InvocationTargetException, IllegalAccessException {
        try {
            Method method = ((MethodSignature)jp.getSignature()).getMethod();
            List<CacheEvict> cacheEvicts = this.getCacheEvicts(method);
            for (CacheEvict cacheEvict : cacheEvicts) {
                this.getCacheHandler(cacheEvict.cache()).clear(this.buildCacheTarget(jp, cacheEvict));
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)("\u7edf\u4e00\u7f13\u5b58,\u7edf\u4e00\u7f13\u5b58\u4ee3\u7406,\u7f13\u5b58\u51fa\u9519,e:" + e.getClass()));
        }
    }

    protected CacheTarget buildCacheTarget(JoinPoint jp, Annotation cacheanno) {
        if (jp == null) {
            return null;
        }
        return new CacheTarget(this.buildObjTarget(jp), this.buildMethTarget(jp, cacheanno), jp instanceof ProceedingJoinPoint ? (ProceedingJoinPoint)jp : null);
    }

    private CacheTarget.ObjTarget buildObjTarget(JoinPoint jp) {
        return new CacheTarget.ObjTarget(jp.getTarget(), (Cached)AnnotationUtils.findAnnotation(jp.getTarget().getClass(), Cached.class));
    }

    private CacheTarget.MethTarget buildMethTarget(JoinPoint jp, Annotation cacheanno) {
        Method method = ((MethodSignature)jp.getSignature()).getMethod();
        return new CacheTarget.MethTarget<Annotation>(method, cacheanno, method.getReturnType(), this.buildParameter(method, jp.getArgs()));
    }

    private List<CacheEvict> getCacheEvicts(Method method) {
        CacheEvicts evicts;
        ArrayList<CacheEvict> cacheEvicts = new ArrayList<CacheEvict>();
        CacheEvict evict = (CacheEvict)AnnotationUtils.findAnnotation((Method)method, CacheEvict.class);
        if (evict != null) {
            cacheEvicts.add(evict);
        }
        if ((evicts = (CacheEvicts)AnnotationUtils.findAnnotation((Method)method, CacheEvicts.class)) != null && evicts.value() != null) {
            for (CacheEvict cacheEvict : evicts.value()) {
                cacheEvicts.add(cacheEvict);
            }
        }
        return cacheEvicts;
    }

    private List<Parameter> buildParameter(Method method, Object ... args) {
        if (args == null || args.length < 1) {
            return Collections.EMPTY_LIST;
        }
        String[] paramNames = ClassUtil.getMethodParamNames(method);
        Class<?>[] parameterTypes = method.getParameterTypes();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Parameter parameter = null;
        int i = 0;
        for (Object arg : args) {
            parameter = new Parameter(paramNames[i], parameterTypes[i], arg);
            parameters.add(parameter);
            ++i;
        }
        return parameters;
    }

    protected CacheHandler getCacheHandler(String cacheEnum) {
        if (CollectionUtils.isEmpty(this.cacheHandlerMap)) {
            return this.defaultCacheHandler;
        }
        CacheHandler cacheHandler = this.cacheHandlerMap.get(cacheEnum);
        if (cacheHandler == null) {
            return this.defaultCacheHandler;
        }
        return cacheHandler;
    }

    public void putCacheHandler(String key, CacheHandler cacheHandler) {
        if (this.cacheHandlerMap == null) {
            this.cacheHandlerMap = new HashMap<String, CacheHandler>();
        }
        this.cacheHandlerMap.put(key, cacheHandler);
    }

    public Map<String, CacheHandler> getCacheHandlerMap() {
        return this.cacheHandlerMap;
    }

    public void setCacheHandlerMap(Map<String, CacheHandler> cacheHandlerMap) {
        this.cacheHandlerMap = cacheHandlerMap;
    }

    public CacheHandler getDefaultCacheHandler() {
        return this.defaultCacheHandler;
    }

    public void setDefaultCacheHandler(CacheHandler defaultCacheHandler) {
        this.defaultCacheHandler = defaultCacheHandler;
    }
}

