/*
 * Decompiled with CFR 0.152.
 */
package com.msimw.mcache.handler;

import com.alibaba.fastjson.JSONObject;
import com.msimw.mcache.annotation.CacheEvict;
import com.msimw.mcache.annotation.Cacheable;
import com.msimw.mcache.handler.CacheHandler;
import com.msimw.mcache.handler.bean.Cache;
import com.msimw.mcache.handler.bean.CacheTarget;
import com.msimw.mcache.handler.bean.Parameter;
import com.msimw.mcache.util.clasz.ClassUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.DigestUtils;

public abstract class AbstractCacheHandler
implements CacheHandler {
    private static final String EMPTY_VALUE = "empty";
    private static final Log LOGGER = LogFactory.getLog(AbstractCacheHandler.class);
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool();

    @Override
    public Object handler(final CacheTarget<Cacheable> cacheTarget) throws Throwable {
        final String groupKey = this.generateGroupKey(cacheTarget);
        Object cache = this.query(groupKey, this.generateKey(cacheTarget), Object.class);
        if (cache == null) {
            final Object serverResult = cacheTarget.noCache();
            EXECUTOR_SERVICE.execute(new Runnable(){

                @Override
                public void run() {
                    Object temp = serverResult;
                    if (temp == null) {
                        temp = AbstractCacheHandler.EMPTY_VALUE;
                    }
                    AbstractCacheHandler.this.save(new Cache(groupKey, AbstractCacheHandler.this.generateKey(cacheTarget), temp, ((Cacheable)cacheTarget.getMethTarget().getCache()).survivalTime()));
                    LOGGER.debug((Object)("\u7edf\u4e00\u6570\u636e\u7f13\u5b58\uff0c\u7f13\u5b58\u6570\u636e\u5230\uff1a[" + groupKey + "]\u5206\u7ec4\u4e0b."));
                }
            });
            return serverResult;
        }
        if (EMPTY_VALUE.equals(cache)) {
            return null;
        }
        LOGGER.debug((Object)("\u7edf\u4e00\u6570\u636e\u7f13\u5b58\uff0c\u4ece[" + groupKey + "]\u5206\u7ec4\u4e0b\u83b7\u53d6\u6570\u636e."));
        return cache;
    }

    @Override
    public void clear(CacheTarget<CacheEvict> cacheTarget) throws Exception {
        String groupKey = this.generateGroupKey(cacheTarget);
        this.clear(groupKey);
        LOGGER.debug((Object)("\u7edf\u4e00\u6570\u636e\u7f13\u5b58,[" + groupKey + "]\u5206\u7ec4\u6709\u66f4\u65b0\uff0c\u6e05\u7a7a\uff1a[" + groupKey + "]\u5206\u7ec4\u4e0b\u7684\u6570\u636e."));
    }

    protected String generateGroupKey(CacheTarget cacheTarget) throws Exception {
        if (cacheTarget == null) {
            return null;
        }
        CacheTarget.MethTarget methTarget = cacheTarget.getMethTarget();
        String pro = this.generateProGroupKey(cacheTarget.getObjTarget(), (Annotation)cacheTarget.getMethTarget().getCache());
        String[] keys = (String[])AnnotationUtils.getValue(cacheTarget.getMethTarget().getCache(), (String)"keys");
        if (keys == null || keys.length < 1) {
            return pro;
        }
        StringBuilder builder = new StringBuilder();
        for (String key : keys) {
            builder.append(":" + this.getKeyValue(methTarget.getParameters(), key));
        }
        return pro + builder.toString();
    }

    private String getKeyValue(List<Parameter> parameters, String key) throws IllegalAccessException {
        if (CollectionUtils.isEmpty(parameters) || key == null) {
            return null;
        }
        if (key.indexOf(".") > 0) {
            String[] split = key.split("\\.");
            return this.pojoHandler(this.getParameter(parameters, split[0]), split[1]);
        }
        for (Parameter parameter : parameters) {
            if (ClassUtil.isWrapClassAndString(parameter.getType())) {
                if (!key.equals(parameter.getName())) continue;
                parameters.remove(parameter);
                return String.valueOf(parameter.getValue());
            }
            return this.pojoHandler(parameter, key);
        }
        return null;
    }

    protected String generateKey(CacheTarget cacheTarget) {
        String key = cacheTarget.getObjTarget().getObj().getClass().getName() + "." + cacheTarget.getMethTarget().getMeth().getName() + "(" + this.buildParamsStr(cacheTarget.getMethTarget().getParameters()) + ")";
        return DigestUtils.md5DigestAsHex((byte[])key.getBytes());
    }

    private String buildParamsStr(List<Parameter> parameters) {
        if (CollectionUtils.isEmpty(parameters)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Parameter parameter : parameters) {
            if (ClassUtil.isWrapClassAndString(parameter.getType())) {
                builder.append("\"" + parameter.getName() + "\":\"" + parameter.getValue() + "\",");
                continue;
            }
            builder.append("\"" + parameter.getName() + "\":" + JSONObject.toJSONString((Object)parameter.getValue()) + ",");
        }
        return builder.toString();
    }

    private String generateProGroupKey(CacheTarget.ObjTarget objTarget, Annotation cache) {
        return objTarget.getCached().value() + ":" + AnnotationUtils.getValue((Annotation)cache);
    }

    private String pojoHandler(Parameter parameter, String key) throws IllegalAccessException {
        try {
            if (key == null || parameter.getValue() == null) {
                return null;
            }
            Field field = parameter.getType().getDeclaredField(key);
            field.setAccessible(true);
            return String.valueOf(field.get(parameter.getValue()));
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private Parameter getParameter(List<Parameter> parameters, String name) {
        if (CollectionUtils.isEmpty(parameters) || name == null) {
            return null;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter parameter = parameters.get(i);
            if (parameter == null) {
                parameters.remove(null);
                continue;
            }
            if (!name.equals(parameter.getName())) continue;
            return parameter;
        }
        return null;
    }

    protected abstract void save(Cache var1);

    protected abstract <T> T query(String var1, String var2, Class<T> var3);

    protected abstract void clear(String var1);
}

