/*
 * Decompiled with CFR 0.152.
 */
package com.msimw.mcache.handler.impl;

import com.msimw.mcache.handler.AbstractCacheHandler;
import com.msimw.mcache.handler.bean.Cache;
import com.msimw.mcache.util.redis.api.RedisClient;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class RedisCacheHandler
extends AbstractCacheHandler {
    private static final Log LOGGER = LogFactory.getLog(RedisCacheHandler.class);
    @Autowired
    private RedisClient redisClient;

    @Override
    public void clearAll(String key) {
        Set<String> keys = this.redisClient.keys(key + "*");
        if (CollectionUtils.isEmpty(keys)) {
            return;
        }
        for (String k : keys) {
            this.redisClient.del(k);
        }
    }

    @Override
    protected void save(Cache cache) {
        this.redisClient.hset(cache.getGroup(), cache.getKey(), cache.getObject());
        if (cache.getSurvivalTime() != -1) {
            this.redisClient.expire(cache.getGroup(), cache.getSurvivalTime());
        }
    }

    @Override
    protected <T> T query(String groupKey, String key, Class<T> clasz) {
        return this.redisClient.hget(groupKey, key, clasz);
    }

    @Override
    protected void clear(String groupKey) {
        this.redisClient.del(groupKey);
    }
}

