/*
 * Decompiled with CFR 0.152.
 */
package com.msimw.mcache.util.redis.impl;

import com.msimw.mcache.util.redis.api.RedisClient;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.SerializationUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisClientSingeSerializeImpl
implements RedisClient {
    @Autowired
    private JedisPool jedisPool;

    @Override
    public <T> T get(final String key, Class<T> clasz) {
        if (StringUtils.isEmpty((Object)key)) {
            return null;
        }
        return (T)new Call(){

            @Override
            protected Object call(Jedis jedis) {
                return SerializationUtils.deserialize((byte[])jedis.get(key.getBytes()));
            }
        }.run(this.jedisPool);
    }

    @Override
    public void set(final String key, final Object value) {
        if (StringUtils.isEmpty((Object)key) || value == null) {
            return;
        }
        new Call(){

            @Override
            protected Object call(Jedis jedis) {
                return jedis.set(key.getBytes(), SerializationUtils.serialize((Object)value));
            }
        }.run(this.jedisPool);
    }

    @Override
    public <T> T hget(final String hkey, final String key, Class<T> clasz) {
        if (StringUtils.isEmpty((Object)hkey) || StringUtils.isEmpty((Object)key) || clasz == null) {
            return null;
        }
        return (T)new Call(){

            @Override
            protected Object call(Jedis jedis) {
                return SerializationUtils.deserialize((byte[])jedis.hget(hkey.getBytes(), key.getBytes()));
            }
        }.run(this.jedisPool);
    }

    @Override
    public void hset(final String hkey, final String key, final Object value) {
        if (StringUtils.isEmpty((Object)hkey) || StringUtils.isEmpty((Object)key) || value == null) {
            return;
        }
        new Call(){

            @Override
            protected Object call(Jedis jedis) {
                return jedis.hset(hkey.getBytes(), key.getBytes(), SerializationUtils.serialize((Object)value));
            }
        }.run(this.jedisPool);
    }

    @Override
    public void expire(final String key, final int second) {
        if (StringUtils.isEmpty((Object)key)) {
            return;
        }
        new Call(){

            @Override
            protected Object call(Jedis jedis) {
                return jedis.expire(key, second);
            }
        }.run(this.jedisPool);
    }

    @Override
    public long ttl(final String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return -1L;
        }
        return (Long)new Call(){

            @Override
            protected Object call(Jedis jedis) {
                return jedis.ttl(key);
            }
        }.run(this.jedisPool);
    }

    @Override
    public void del(final String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return;
        }
        new Call(){

            @Override
            protected Object call(Jedis jedis) {
                return jedis.del(key);
            }
        }.run(this.jedisPool);
    }

    @Override
    public void hdel(final String hkey, final String key) {
        if (StringUtils.isEmpty((Object)hkey) || StringUtils.isEmpty((Object)key)) {
            return;
        }
        new Call(){

            @Override
            protected Object call(Jedis jedis) {
                return jedis.hdel(hkey, new String[]{key});
            }
        }.run(this.jedisPool);
    }

    @Override
    public Set<String> keys(final String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return null;
        }
        return (Set)new Call(){

            @Override
            protected Object call(Jedis jedis) {
                return jedis.keys(key);
            }
        }.run(this.jedisPool);
    }

    @Override
    public Set<String> hkeys(final String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return null;
        }
        return (Set)new Call(){

            @Override
            protected Object call(Jedis jedis) {
                return jedis.hkeys(key);
            }
        }.run(this.jedisPool);
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    public void setJedisPool(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    private abstract class Call {
        private Call() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run(JedisPool jedisPool) {
            try (Jedis jedis = null;){
                jedis = jedisPool.getResource();
                Object object = this.call(jedis);
                return object;
            }
        }

        protected abstract Object call(Jedis var1);
    }
}

