/*
 * Decompiled with CFR 0.152.
 */
package com.github.mtakaki.dropwizard.admin;

import com.codahale.metrics.jersey3.InstrumentedResourceMethodApplicationListener;
import com.github.mtakaki.dropwizard.admin.DropwizardAdminResourceConfig;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.jersey.DropwizardResourceConfig;
import io.dropwizard.jersey.setup.JerseyContainerHolder;
import io.dropwizard.jersey.setup.JerseyEnvironment;
import jakarta.servlet.Servlet;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.RolesAllowedDynamicFeature;
import org.glassfish.jersey.servlet.ServletContainer;

public class AdminResourceBundle<T>
implements ConfiguredBundle<T> {
    private final String basePath;
    private JerseyEnvironment jerseyEnvironment;

    public AdminResourceBundle() {
        this("/admin");
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T config, Environment environment) {
        this.jerseyEnvironment = this.setupAdminEnvironment(environment);
    }

    private JerseyEnvironment setupAdminEnvironment(Environment environment) {
        DropwizardAdminResourceConfig jerseyConfig = new DropwizardAdminResourceConfig(environment.metrics());
        JerseyContainerHolder servletContainer = new JerseyContainerHolder((Servlet)new ServletContainer((ResourceConfig)jerseyConfig));
        JerseyEnvironment tempJerseyEnvironment = new JerseyEnvironment(servletContainer, (DropwizardResourceConfig)jerseyConfig);
        environment.admin().addServlet("admin resources", servletContainer.getContainer()).addMapping(new String[]{String.format("%s/*", this.basePath)});
        tempJerseyEnvironment.register((Object)new InstrumentedResourceMethodApplicationListener(environment.metrics()));
        tempJerseyEnvironment.register((Object)new RolesAllowedDynamicFeature());
        return tempJerseyEnvironment;
    }

    public AdminResourceBundle(String basePath) {
        this.basePath = basePath;
    }

    public JerseyEnvironment getJerseyEnvironment() {
        return this.jerseyEnvironment;
    }
}

