/*
 * Decompiled with CFR 0.152.
 */
package chameleon.playlist.asx;

import chameleon.content.Content;
import chameleon.lang.StringUtils;
import chameleon.playlist.AbstractPlaylistComponent;
import chameleon.playlist.Media;
import chameleon.playlist.Playlist;
import chameleon.playlist.Sequence;
import chameleon.playlist.SpecificPlaylist;
import chameleon.playlist.SpecificPlaylistProvider;
import chameleon.playlist.asx.AsxElement;
import chameleon.playlist.asx.AsxElementContainer;
import chameleon.playlist.asx.AsxOrEntryElement;
import chameleon.playlist.asx.Duration;
import chameleon.playlist.asx.Entry;
import chameleon.playlist.asx.Entryref;
import chameleon.playlist.asx.Reference;
import chameleon.playlist.asx.Repeat;
import chameleon.xml.XmlSerializer;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class Asx
extends AsxOrEntryElement
implements SpecificPlaylist,
AsxElementContainer {
    private transient SpecificPlaylistProvider _provider = null;
    private String _version = "3.0";
    private boolean _previewMode = false;
    private String _bannerBar = null;
    private final List<AsxElement> _asxElements = new ArrayList<AsxElement>();

    public void setProvider(SpecificPlaylistProvider provider) {
        this._provider = provider;
    }

    public SpecificPlaylistProvider getProvider() {
        return this._provider;
    }

    public void writeTo(OutputStream out, String encoding) throws Exception {
        StringWriter writer = new StringWriter();
        XmlSerializer serializer = XmlSerializer.getMapping((String)"chameleon/playlist/asx");
        serializer.getMarshaller().setProperty("org.exolab.castor.indent", "true");
        serializer.marshal((Object)this, (Writer)writer, false);
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        byte[] bytes = writer.toString().getBytes(enc);
        out.write(bytes);
        out.flush();
    }

    public Playlist toPlaylist() {
        Playlist ret = new Playlist();
        for (AsxElement asxElement : this._asxElements) {
            this.addToSequence(asxElement, ret.getRootSequence());
        }
        ret.normalize();
        return ret;
    }

    private void addToSequence(AsxElement asxElement, Sequence currentSequence) {
        Entryref entryRef;
        if (asxElement instanceof Repeat) {
            Repeat repeat = (Repeat)asxElement;
            Sequence seq = new Sequence();
            seq.setRepeatCount(repeat.getCount() == null ? -1 : repeat.getCount() + 1);
            currentSequence.addComponent((AbstractPlaylistComponent)seq);
            for (AsxElement asxElem : repeat.getAsxElements()) {
                this.addToSequence(asxElem, seq);
            }
        } else if (asxElement instanceof Entry) {
            Entry entry = (Entry)asxElement;
            for (Reference reference : entry.getReferences()) {
                if (reference.getHref() == null) continue;
                Duration duration = reference.getDuration();
                if (duration == null) {
                    duration = entry.getDuration();
                }
                if (duration != null && duration.getValue() <= 0L) continue;
                Media media = new Media();
                media.setSource(new Content(reference.getHref()));
                if (duration != null) {
                    media.setDuration(duration.getValue());
                }
                currentSequence.addComponent((AbstractPlaylistComponent)media);
                break;
            }
        } else if (asxElement instanceof Entryref && (entryRef = (Entryref)asxElement).getHref() != null) {
            Media media = new Media();
            media.setSource(new Content(entryRef.getHref()));
            currentSequence.addComponent((AbstractPlaylistComponent)media);
        }
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        this._version = version.trim();
    }

    public String getBannerBar() {
        return this._bannerBar;
    }

    public void setBannerBar(String bannerBar) {
        String banner = StringUtils.normalize((String)bannerBar);
        this._bannerBar = "FIXED".equalsIgnoreCase(banner) ? "FIXED" : null;
    }

    public String getPreviewModeString() {
        String ret = null;
        if (this._previewMode) {
            ret = "YES";
        }
        return ret;
    }

    public void setPreviewModeString(String previewMode) {
        String preview = StringUtils.normalize((String)previewMode);
        this._previewMode = "YES".equalsIgnoreCase(preview);
    }

    public boolean isPreviewMode() {
        return this._previewMode;
    }

    public void setPreviewMode(boolean previewMode) {
        this._previewMode = previewMode;
    }

    @Override
    public void addAsxElement(AsxElement asxElement) {
        if (asxElement instanceof Asx) {
            throw new IllegalStateException("Element not valid here: " + asxElement);
        }
        asxElement.setParent(this);
        this._asxElements.add(asxElement);
    }

    @Override
    public List<AsxElement> getAsxElements() {
        return this._asxElements;
    }
}

