/*
 * Decompiled with CFR 0.152.
 */
package chameleon.playlist.asx;

import chameleon.content.type.ContentType;
import chameleon.io.IOUtils;
import chameleon.player.PlayerSupport;
import chameleon.playlist.AbstractPlaylistComponent;
import chameleon.playlist.Media;
import chameleon.playlist.Parallel;
import chameleon.playlist.Playlist;
import chameleon.playlist.Sequence;
import chameleon.playlist.SpecificPlaylist;
import chameleon.playlist.SpecificPlaylistProvider;
import chameleon.playlist.asx.Asx;
import chameleon.playlist.asx.AsxElementContainer;
import chameleon.playlist.asx.Duration;
import chameleon.playlist.asx.Entry;
import chameleon.playlist.asx.Entryref;
import chameleon.playlist.asx.Reference;
import chameleon.playlist.asx.Repeat;
import chameleon.xml.XmlSerializer;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.logging.Log;

public class AsxProvider
implements SpecificPlaylistProvider {
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".asx"}, new String[]{"video/x-ms-asf"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.WINAMP, false, null), new PlayerSupport(PlayerSupport.Player.VLC_MEDIA_PLAYER, false, null), new PlayerSupport(PlayerSupport.Player.WINDOWS_MEDIA_PLAYER, true, null), new PlayerSupport(PlayerSupport.Player.MEDIA_PLAYER_CLASSIC, true, null), new PlayerSupport(PlayerSupport.Player.REALPLAYER, false, null)}, "Advanced Stream Redirector (ASX)"), new ContentType(new String[]{".wmx"}, new String[]{"video/x-ms-wvx"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.REALPLAYER, false, null)}, "Windows Media Redirector (WMX)"), new ContentType(new String[]{".wvx"}, new String[]{"video/x-ms-wvx"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.WINDOWS_MEDIA_PLAYER, false, null), new PlayerSupport(PlayerSupport.Player.MEDIA_PLAYER_CLASSIC, false, null), new PlayerSupport(PlayerSupport.Player.REALPLAYER, false, null)}, "Windows Media Video Redirector (WVX)"), new ContentType(new String[]{".wax"}, new String[]{"audio/x-ms-wax"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.WINDOWS_MEDIA_PLAYER, false, null), new PlayerSupport(PlayerSupport.Player.MEDIA_PLAYER_CLASSIC, false, null), new PlayerSupport(PlayerSupport.Player.REALPLAYER, false, null)}, "Windows Media Audio Redirector (WAX)")};

    public String getId() {
        return "asx";
    }

    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    public SpecificPlaylist readFrom(InputStream in, String encoding, Log logger) throws Exception {
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        String str = IOUtils.toString((InputStream)in, (String)enc);
        str = str.replace("&", "&amp;");
        str = str.replaceAll("&amp;([a-zA-Z0-9#]+;)", "&$1");
        StringBuilder sb = new StringBuilder();
        int len = str.length();
        boolean inElement = false;
        boolean inAttribute = false;
        int previousChar = 32;
        int attributeSeparator = 34;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '<': {
                    inElement = true;
                    inAttribute = true;
                    sb.append(c);
                    break;
                }
                case '>': {
                    inElement = false;
                    inAttribute = false;
                    sb.append(c);
                    break;
                }
                case '\"': {
                    if (inElement && previousChar != 92) {
                        if (inAttribute) {
                            attributeSeparator = 34;
                            inAttribute = false;
                        } else if (attributeSeparator == 34) {
                            inAttribute = true;
                        }
                    }
                    sb.append(c);
                    break;
                }
                case '\'': {
                    if (inElement && previousChar != 92) {
                        if (inAttribute) {
                            attributeSeparator = 39;
                            inAttribute = false;
                        } else if (attributeSeparator == 39) {
                            inAttribute = true;
                        }
                    }
                    sb.append(c);
                    break;
                }
                default: {
                    if (inElement && inAttribute) {
                        sb.append(Character.toLowerCase(c));
                        break;
                    }
                    sb.append(c);
                }
            }
            previousChar = c;
        }
        str = sb.toString();
        XmlSerializer serializer = XmlSerializer.getMapping((String)"chameleon/playlist/asx");
        serializer.getUnmarshaller().setIgnoreExtraElements(false);
        StringReader reader = new StringReader(str);
        SpecificPlaylist ret = (SpecificPlaylist)serializer.unmarshal((Reader)reader);
        ret.setProvider((SpecificPlaylistProvider)this);
        return ret;
    }

    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) throws Exception {
        Asx ret = new Asx();
        ret.setProvider(this);
        this.addToPlaylist(ret, (AbstractPlaylistComponent)playlist.getRootSequence());
        return ret;
    }

    private void addToPlaylist(AsxElementContainer container, AbstractPlaylistComponent component) throws Exception {
        if (component instanceof Sequence) {
            Sequence sequence = (Sequence)component;
            if (sequence.getRepeatCount() != 0) {
                AbstractPlaylistComponent[] components;
                Repeat repeat;
                AsxElementContainer newContainer = container;
                if (sequence.getRepeatCount() < 0) {
                    repeat = new Repeat();
                    container.addAsxElement(repeat);
                    newContainer = repeat;
                } else if (sequence.getRepeatCount() > 1) {
                    repeat = new Repeat();
                    repeat.setCount(sequence.getRepeatCount() - 1);
                    container.addAsxElement(repeat);
                    newContainer = repeat;
                }
                for (AbstractPlaylistComponent c : components = sequence.getComponents()) {
                    this.addToPlaylist(newContainer, c);
                }
            }
        } else {
            Media media;
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("A parallel time container is incompatible with an ASX playlist");
            }
            if (component instanceof Media && (media = (Media)component).getRepeatCount() != 0 && media.getSource() != null) {
                Repeat repeat;
                AsxElementContainer newContainer = container;
                if (media.getRepeatCount() < 0) {
                    repeat = new Repeat();
                    container.addAsxElement(repeat);
                    newContainer = repeat;
                } else if (media.getRepeatCount() > 1) {
                    repeat = new Repeat();
                    repeat.setCount(media.getRepeatCount() - 1);
                    container.addAsxElement(repeat);
                    newContainer = repeat;
                }
                boolean isPlaylist = false;
                String path = media.getSource().toString().toLowerCase();
                for (ContentType type : FILETYPES) {
                    for (String extension : type.getExtensions()) {
                        isPlaylist = isPlaylist || path.endsWith(extension);
                    }
                }
                if (isPlaylist) {
                    if (media.getDuration() != null) {
                        throw new IllegalArgumentException("An ASX playlist referenced in another ASX playlist cannot be timed");
                    }
                    Entryref entryRef = new Entryref();
                    entryRef.setHref(media.getSource().toString());
                    newContainer.addAsxElement(entryRef);
                } else {
                    Entry entry = new Entry();
                    Reference reference = new Reference();
                    reference.setHref(media.getSource().toString());
                    if (media.getDuration() != null) {
                        Duration duration = new Duration();
                        duration.setValue(media.getDuration());
                        reference.setDuration(duration);
                    }
                    entry.addReference(reference);
                    newContainer.addAsxElement(entry);
                }
            }
        }
    }
}

