/*
 * Decompiled with CFR 0.152.
 */
package chameleon.playlist.atom;

import chameleon.atom.Entry;
import chameleon.atom.Feed;
import chameleon.atom.Link;
import chameleon.content.Content;
import chameleon.playlist.AbstractPlaylistComponent;
import chameleon.playlist.Media;
import chameleon.playlist.Playlist;
import chameleon.playlist.SpecificPlaylist;
import chameleon.playlist.SpecificPlaylistProvider;
import chameleon.xml.XmlSerializer;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;

public class AtomPlaylist
implements SpecificPlaylist {
    private transient SpecificPlaylistProvider _provider = null;
    private Feed _feed = new Feed();

    public void setProvider(SpecificPlaylistProvider provider) {
        this._provider = provider;
    }

    public SpecificPlaylistProvider getProvider() {
        return this._provider;
    }

    public void writeTo(OutputStream out, String encoding) throws Exception {
        StringWriter writer = new StringWriter();
        XmlSerializer serializer = XmlSerializer.getMapping((String)"chameleon/atom");
        serializer.getMarshaller().setProperty("org.exolab.castor.indent", "true");
        serializer.marshal((Object)this._feed, (Writer)writer, false);
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        byte[] bytes = writer.toString().getBytes(enc);
        out.write(bytes);
        out.flush();
    }

    public Playlist toPlaylist() {
        Playlist ret = new Playlist();
        for (Entry entry : this._feed.getEntries()) {
            for (Link link : entry.getLinks()) {
                if (link.getHref() == null || !"enclosure".equals(link.getRel())) continue;
                Media media = new Media();
                Content content = new Content(link.getHref());
                content.setType(link.getType());
                if (link.getLength() != null) {
                    content.setLength(link.getLength().longValue());
                }
                media.setSource(content);
                ret.getRootSequence().addComponent((AbstractPlaylistComponent)media);
            }
        }
        ret.normalize();
        return ret;
    }

    public Feed getFeed() {
        return this._feed;
    }

    public void setFeed(Feed feed) {
        if (feed == null) {
            throw new NullPointerException("No Atom Feed Document");
        }
        this._feed = feed;
    }
}

