/*
 * Decompiled with CFR 0.152.
 */
package chameleon.playlist.atom;

import chameleon.atom.Entry;
import chameleon.atom.Feed;
import chameleon.atom.Generator;
import chameleon.atom.Link;
import chameleon.atom.Person;
import chameleon.atom.TextContainer;
import chameleon.atom.URIContainer;
import chameleon.content.type.ContentType;
import chameleon.io.IOUtils;
import chameleon.player.PlayerSupport;
import chameleon.playlist.AbstractPlaylistComponent;
import chameleon.playlist.Media;
import chameleon.playlist.Parallel;
import chameleon.playlist.Playlist;
import chameleon.playlist.Sequence;
import chameleon.playlist.SpecificPlaylist;
import chameleon.playlist.SpecificPlaylistProvider;
import chameleon.playlist.atom.AtomPlaylist;
import chameleon.xml.Version;
import chameleon.xml.XmlSerializer;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.Date;
import org.apache.commons.logging.Log;

public class AtomProvider
implements SpecificPlaylistProvider {
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".atom", ".xml"}, new String[]{"application/atom+xml"}, new PlayerSupport[0], "Atom Document")};

    public String getId() {
        return "atom";
    }

    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    public SpecificPlaylist readFrom(InputStream in, String encoding, Log logger) throws Exception {
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        String str = IOUtils.toString((InputStream)in, (String)enc);
        str = str.replace("&", "&amp;");
        str = str.replaceAll("&amp;([a-zA-Z0-9#]+;)", "&$1");
        str = str.replace("xmlns=\"http://www.w3.org/2005/Atom\"", "");
        XmlSerializer serializer = XmlSerializer.getMapping((String)"chameleon/atom");
        serializer.getUnmarshaller().setIgnoreExtraElements(true);
        StringReader reader = new StringReader(str);
        Feed feed = (Feed)serializer.unmarshal((Reader)reader);
        AtomPlaylist ret = new AtomPlaylist();
        ret.setProvider(this);
        ret.setFeed(feed);
        return ret;
    }

    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) throws Exception {
        AtomPlaylist ret = new AtomPlaylist();
        ret.setProvider(this);
        Feed feed = ret.getFeed();
        TextContainer title = new TextContainer();
        title.setText("Chamelon v" + Version.CURRENT + " Atom playlist");
        feed.setTitle(title);
        feed.setUpdated(new Date());
        URIContainer id = new URIContainer();
        StringBuilder sb = new StringBuilder();
        sb.append("urn:uuid:");
        String tmpId = Integer.toHexString(System.identityHashCode(feed));
        for (int i = tmpId.length(); i < 8; ++i) {
            sb.append('0');
        }
        sb.append(tmpId);
        sb.append("-d399-11d9-b93C-0003939e0af6");
        id.setURIString(sb.toString());
        feed.setId(id);
        Generator generator = new Generator();
        generator.setValue("Chameleon");
        generator.setVersion(Version.CURRENT.toString());
        generator.setURIString("https://github.com/muff1nman/chameleon.git");
        feed.setGenerator(generator);
        Person me = new Person();
        me.setName("Christophe Delory");
        me.setURIString("https://github.com/muff1nman/chameleon.git");
        me.setEmail("");
        feed.addContributor(me);
        this.addToPlaylist(feed, (AbstractPlaylistComponent)playlist.getRootSequence());
        return ret;
    }

    private void addToPlaylist(Feed feed, AbstractPlaylistComponent component) throws Exception {
        block15: {
            block14: {
                if (!(component instanceof Sequence)) break block14;
                Sequence sequence = (Sequence)component;
                if (sequence.getRepeatCount() < 0) {
                    throw new IllegalArgumentException("An Atom playlist cannot handle a sequence repeated indefinitely");
                }
                AbstractPlaylistComponent[] components = sequence.getComponents();
                for (int iter = 0; iter < sequence.getRepeatCount(); ++iter) {
                    for (AbstractPlaylistComponent c : components) {
                        this.addToPlaylist(feed, c);
                    }
                }
                break block15;
            }
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("An Atom playlist doesn't support concurrent media");
            }
            if (!(component instanceof Media)) break block15;
            Media media = (Media)component;
            if (media.getDuration() != null) {
                throw new IllegalArgumentException("An Atom playlist cannot handle a timed media");
            }
            if (media.getRepeatCount() < 0) {
                throw new IllegalArgumentException("An Atom playlist cannot handle a media repeated indefinitely");
            }
            if (media.getSource() != null) {
                for (int iter = 0; iter < media.getRepeatCount(); ++iter) {
                    Entry entry = new Entry();
                    Link link = new Link();
                    URI uri = media.getSource().getURI();
                    link.setHref(uri.toString());
                    link.setRel("enclosure");
                    link.setType(media.getSource().getType());
                    if (media.getSource().getLength() >= 0L) {
                        link.setLength(media.getSource().getLength());
                    }
                    entry.addLink(link);
                    TextContainer title = new TextContainer();
                    if (uri.getPath() == null) {
                        title.setText(media.getSource().toString());
                    } else {
                        File path = new File(uri.getPath());
                        title.setText(path.getName());
                    }
                    entry.setTitle(title);
                    if (media.getSource().getLastModified() > 0L) {
                        entry.setUpdated(new Date(media.getSource().getLastModified()));
                    } else {
                        entry.setUpdated(new Date());
                    }
                    entry.setPublished(new Date());
                    URIContainer id = new URIContainer();
                    StringBuilder sb = new StringBuilder();
                    sb.append("urn:uuid:");
                    String tmpId = Integer.toHexString(System.identityHashCode(entry));
                    for (int i = tmpId.length(); i < 8; ++i) {
                        sb.append('0');
                    }
                    sb.append(tmpId);
                    sb.append("-d399-11d9-b93C-0003939e0af6");
                    id.setURIString(sb.toString());
                    entry.setId(id);
                    feed.addEntry(entry);
                }
            }
        }
    }
}

