/*
 * Decompiled with CFR 0.152.
 */
package chameleon.playlist.b4s;

import chameleon.content.Content;
import chameleon.playlist.AbstractPlaylistComponent;
import chameleon.playlist.Media;
import chameleon.playlist.SpecificPlaylist;
import chameleon.playlist.SpecificPlaylistProvider;
import chameleon.playlist.b4s.Entry;
import chameleon.playlist.b4s.Playlist;
import chameleon.xml.XmlSerializer;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;

public class WinampXML
implements SpecificPlaylist {
    private transient SpecificPlaylistProvider _provider = null;
    private Playlist _playlist = new Playlist();

    public void setProvider(SpecificPlaylistProvider provider) {
        this._provider = provider;
    }

    public SpecificPlaylistProvider getProvider() {
        return this._provider;
    }

    public void writeTo(OutputStream out, String encoding) throws Exception {
        StringWriter writer = new StringWriter();
        XmlSerializer serializer = XmlSerializer.getMapping((String)"chameleon/playlist/b4s");
        serializer.getMarshaller().setProperty("org.exolab.castor.indent", "true");
        serializer.marshal((Object)this, (Writer)writer, false);
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        byte[] bytes = writer.toString().getBytes(enc);
        out.write(bytes);
        out.flush();
    }

    public chameleon.playlist.Playlist toPlaylist() {
        chameleon.playlist.Playlist ret = new chameleon.playlist.Playlist();
        for (Entry entry : this._playlist.getEntries()) {
            if (entry.getPlaystring() == null) continue;
            Media media = new Media();
            Content content = new Content(entry.getPlaystring());
            if (entry.getLength() != null) {
                content.setLength(entry.getLength().longValue());
            }
            media.setSource(content);
            ret.getRootSequence().addComponent((AbstractPlaylistComponent)media);
        }
        ret.normalize();
        return ret;
    }

    public Playlist getPlaylist() {
        return this._playlist;
    }

    public void setPlaylist(Playlist playlist) {
        if (playlist == null) {
            throw new NullPointerException("no playlist");
        }
        this._playlist = playlist;
    }
}

