/*
 * Decompiled with CFR 0.152.
 */
package chameleon.playlist.hypetape;

import chameleon.content.type.ContentType;
import chameleon.io.IOUtils;
import chameleon.player.PlayerSupport;
import chameleon.playlist.AbstractPlaylistComponent;
import chameleon.playlist.Media;
import chameleon.playlist.Parallel;
import chameleon.playlist.Playlist;
import chameleon.playlist.Sequence;
import chameleon.playlist.SpecificPlaylist;
import chameleon.playlist.SpecificPlaylistProvider;
import chameleon.playlist.hypetape.Track;
import chameleon.xml.XmlSerializer;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.logging.Log;

public class HypetapeProvider
implements SpecificPlaylistProvider {
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".hypetape", ".xml"}, new String[]{"text/xml"}, new PlayerSupport[0], "Hypetape XML Playlist Format")};

    public String getId() {
        return "hypetape";
    }

    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    public SpecificPlaylist readFrom(InputStream in, String encoding, Log logger) throws Exception {
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        String str = IOUtils.toString((InputStream)in, (String)enc);
        str = str.replace("&", "&amp;");
        str = str.replaceAll("&amp;([a-zA-Z0-9#]+;)", "&$1");
        XmlSerializer serializer = XmlSerializer.getMapping((String)"chameleon/playlist/hypetape");
        serializer.getUnmarshaller().setIgnoreExtraElements(false);
        StringReader reader = new StringReader(str);
        SpecificPlaylist ret = (SpecificPlaylist)serializer.unmarshal((Reader)reader);
        ret.setProvider((SpecificPlaylistProvider)this);
        return ret;
    }

    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) throws Exception {
        chameleon.playlist.hypetape.Playlist ret = new chameleon.playlist.hypetape.Playlist();
        ret.setProvider(this);
        this.addToPlaylist(ret, (AbstractPlaylistComponent)playlist.getRootSequence());
        return ret;
    }

    private void addToPlaylist(chameleon.playlist.hypetape.Playlist playlist, AbstractPlaylistComponent component) throws Exception {
        block9: {
            block8: {
                if (!(component instanceof Sequence)) break block8;
                Sequence sequence = (Sequence)component;
                if (sequence.getRepeatCount() < 0) {
                    throw new IllegalArgumentException("A Hypetape playlist cannot handle a sequence repeated indefinitely");
                }
                AbstractPlaylistComponent[] components = sequence.getComponents();
                for (int iter = 0; iter < sequence.getRepeatCount(); ++iter) {
                    for (AbstractPlaylistComponent c : components) {
                        this.addToPlaylist(playlist, c);
                    }
                }
                break block9;
            }
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("A Hypetape playlist cannot play different media at the same time");
            }
            if (!(component instanceof Media)) break block9;
            Media media = (Media)component;
            if (media.getDuration() != null) {
                throw new IllegalArgumentException("A Hypetape playlist cannot handle a timed media");
            }
            if (media.getRepeatCount() < 0) {
                throw new IllegalArgumentException("A Hypetape playlist cannot handle a media repeated indefinitely");
            }
            if (media.getSource() != null) {
                for (int iter = 0; iter < media.getRepeatCount(); ++iter) {
                    Track track = new Track();
                    track.setId(Integer.toString(System.identityHashCode(media.getSource())));
                    track.setName(media.getSource().toString());
                    track.setMP3(media.getSource().toString());
                    playlist.addTrack(track);
                }
            }
        }
    }
}

