/*
 * Decompiled with CFR 0.152.
 */
package chameleon.playlist.hypetape;

import chameleon.content.Content;
import chameleon.playlist.AbstractPlaylistComponent;
import chameleon.playlist.Media;
import chameleon.playlist.SpecificPlaylist;
import chameleon.playlist.SpecificPlaylistProvider;
import chameleon.playlist.hypetape.Track;
import chameleon.xml.XmlSerializer;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class Playlist
implements SpecificPlaylist {
    private transient SpecificPlaylistProvider _provider = null;
    private final List<Track> _tracks = new ArrayList<Track>();

    public void setProvider(SpecificPlaylistProvider provider) {
        this._provider = provider;
    }

    public SpecificPlaylistProvider getProvider() {
        return this._provider;
    }

    public void writeTo(OutputStream out, String encoding) throws Exception {
        StringWriter writer = new StringWriter();
        XmlSerializer serializer = XmlSerializer.getMapping((String)"chameleon/playlist/hypetape");
        serializer.getMarshaller().setProperty("org.exolab.castor.indent", "true");
        serializer.marshal((Object)this, (Writer)writer, false);
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        byte[] bytes = writer.toString().getBytes(enc);
        out.write(bytes);
        out.flush();
    }

    public chameleon.playlist.Playlist toPlaylist() {
        chameleon.playlist.Playlist ret = new chameleon.playlist.Playlist();
        for (Track track : this._tracks) {
            if (track.getMP3() == null) continue;
            Media media = new Media();
            Content content = new Content(track.getMP3());
            media.setSource(content);
            ret.getRootSequence().addComponent((AbstractPlaylistComponent)media);
        }
        ret.normalize();
        return ret;
    }

    public void addTrack(Track track) {
        if (track == null) {
            throw new NullPointerException("no track");
        }
        this._tracks.add(track);
    }

    public List<Track> getTracks() {
        return this._tracks;
    }
}

